/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.optimizer;

import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.optimizer.Optimizer;
import de.mirkosertic.bytecoder.optimizer.OptimizerStage;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.ExpressionListContainer;
import de.mirkosertic.bytecoder.ssa.RegionNode;

public class SinglePassOptimizer
implements Optimizer {
    private final OptimizerStage[] stages;

    public SinglePassOptimizer(OptimizerStage[] stages) {
        this.stages = stages;
    }

    @Override
    public void optimize(ControlFlowGraph aGraph, BytecodeLinkerContext aLinkerContext) {
        for (RegionNode theNode : aGraph.dominators().getPreOrder()) {
            this.optimize(aGraph, aLinkerContext, theNode, theNode.getExpressions());
        }
    }

    private void optimize(ControlFlowGraph aGraph, BytecodeLinkerContext aLinkerContext, RegionNode aCurrentNode, ExpressionList aExpressionList) {
        for (Expression theExpression : aExpressionList.toList()) {
            if (theExpression instanceof ExpressionListContainer) {
                ExpressionListContainer theContainer = (ExpressionListContainer)((Object)theExpression);
                for (ExpressionList theList : theContainer.getExpressionLists()) {
                    this.optimize(aGraph, aLinkerContext, aCurrentNode, theList);
                }
            }
            Expression theStart = theExpression;
            for (OptimizerStage theStage : this.stages) {
                if (theStart == null) continue;
                theStart = theStage.optimize(aGraph, aLinkerContext, aCurrentNode, aExpressionList, theStart);
            }
        }
    }
}

