/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.optimizer;

import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.optimizer.OptimizerStage;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.PutFieldExpression;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;

public class MemberFieldWriteOptimizerStage
implements OptimizerStage {
    @Override
    public Expression optimize(ControlFlowGraph aGraph, BytecodeLinkerContext aLinkerContext, RegionNode aCurrentNode, ExpressionList aExpressionList, Expression aExpression) {
        while (aExpression instanceof PutFieldExpression) {
            PutFieldExpression theFieldWrite = (PutFieldExpression)aExpression;
            Value theTarget = (Value)theFieldWrite.incomingDataFlows().get(0);
            Value theValue = (Value)theFieldWrite.incomingDataFlows().get(1);
            Expression theBefore = aExpressionList.predecessorOf(theFieldWrite);
            if (!(theBefore instanceof VariableAssignmentExpression)) break;
            VariableAssignmentExpression theBeforeAssignment = (VariableAssignmentExpression)theBefore;
            if (theBeforeAssignment.getVariable() == theTarget && theTarget.outgoingEdges().count() == 1L && !aCurrentNode.liveOut().contains(theBeforeAssignment.getVariable())) {
                theFieldWrite.replaceIncomingDataEdge(theTarget, (Value)theBeforeAssignment.incomingDataFlows().get(0));
                aGraph.getProgram().deleteVariable(theBeforeAssignment.getVariable());
                aExpressionList.remove(theBeforeAssignment);
                continue;
            }
            if (theBeforeAssignment.getVariable() != theValue || theValue.outgoingEdges().count() != 1L || aCurrentNode.liveOut().contains(theBeforeAssignment.getVariable())) break;
            theFieldWrite.replaceIncomingDataEdge(theValue, (Value)theBeforeAssignment.incomingDataFlows().get(0));
            aGraph.getProgram().deleteVariable(theBeforeAssignment.getVariable());
            aExpressionList.remove(theBeforeAssignment);
        }
        return aExpression;
    }
}

