/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.optimizer;

import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.optimizer.OptimizerStage;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.GetFieldExpression;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;

public class MemberFieldReadOptimizerStage
implements OptimizerStage {
    @Override
    public Expression optimize(ControlFlowGraph aGraph, BytecodeLinkerContext aLinkerContext, RegionNode aCurrentNode, ExpressionList aExpressionList, Expression aExpression) {
        VariableAssignmentExpression theFieldReadAssignment;
        Value theRightSide;
        if (aExpression instanceof VariableAssignmentExpression && (theRightSide = (Value)(theFieldReadAssignment = (VariableAssignmentExpression)aExpression).incomingDataFlows().get(0)) instanceof GetFieldExpression) {
            VariableAssignmentExpression theBeforeAssignment;
            Value theTarget = (Value)theRightSide.incomingDataFlows().get(0);
            Expression theBefore = aExpressionList.predecessorOf(theFieldReadAssignment);
            if (theBefore instanceof VariableAssignmentExpression && (theBeforeAssignment = (VariableAssignmentExpression)theBefore).getVariable() == theTarget && theTarget.outgoingEdges().count() == 1L && !aCurrentNode.liveOut().contains(theTarget)) {
                theRightSide.replaceIncomingDataEdge(theTarget, (Value)theBeforeAssignment.incomingDataFlows().get(0));
                aGraph.getProgram().deleteVariable(theBeforeAssignment.getVariable());
                aExpressionList.remove(theBeforeAssignment);
                return theFieldReadAssignment;
            }
        }
        return aExpression;
    }
}

