/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.optimizer;

import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.optimizer.ArrayEntryReadOptimizerStage;
import de.mirkosertic.bytecoder.optimizer.ArrayEntryWriteOptimizerStage;
import de.mirkosertic.bytecoder.optimizer.ArrayReadLengthOptimizerStage;
import de.mirkosertic.bytecoder.optimizer.BinaryExpressionOptimizerStage;
import de.mirkosertic.bytecoder.optimizer.InefficientCompareOptimizerStage;
import de.mirkosertic.bytecoder.optimizer.InlineCallArgumentsOptimizerStage;
import de.mirkosertic.bytecoder.optimizer.InlineConstVariablesOptimizer;
import de.mirkosertic.bytecoder.optimizer.InlineMethodParameterOptimizer;
import de.mirkosertic.bytecoder.optimizer.InvokeVirtualOptimizerStage;
import de.mirkosertic.bytecoder.optimizer.MemberFieldReadOptimizerStage;
import de.mirkosertic.bytecoder.optimizer.MemberFieldWriteOptimizerStage;
import de.mirkosertic.bytecoder.optimizer.Optimizer;
import de.mirkosertic.bytecoder.optimizer.OptimizerStage;
import de.mirkosertic.bytecoder.optimizer.SinglePassOptimizer;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import java.util.ArrayList;
import java.util.List;

public enum KnownOptimizer implements Optimizer
{
    NONE{

        @Override
        public void optimize(ControlFlowGraph aGraph, BytecodeLinkerContext aLinkerContext) {
        }
    }
    ,
    ALL{

        @Override
        public void optimize(ControlFlowGraph aGraph, BytecodeLinkerContext aLinkerContext) {
            ArrayList<Optimizer> theOptimizer = new ArrayList<Optimizer>();
            theOptimizer.add(new InlineMethodParameterOptimizer());
            theOptimizer.add(new InlineConstVariablesOptimizer());
            theOptimizer.add(new SinglePassOptimizer(new OptimizerStage[]{new InvokeVirtualOptimizerStage(), new InefficientCompareOptimizerStage(), new InlineCallArgumentsOptimizerStage(), new MemberFieldReadOptimizerStage(), new MemberFieldWriteOptimizerStage(), new ArrayEntryReadOptimizerStage(), new ArrayEntryWriteOptimizerStage(), new ArrayReadLengthOptimizerStage(), new BinaryExpressionOptimizerStage()}));
            KnownOptimizer.run(aGraph, aLinkerContext, theOptimizer);
        }
    }
    ,
    EXPERIMENTAL{

        @Override
        public void optimize(ControlFlowGraph aGraph, BytecodeLinkerContext aLinkerContext) {
            ArrayList<KnownOptimizer> theOptimizer = new ArrayList<KnownOptimizer>();
            theOptimizer.add(ALL);
            KnownOptimizer.run(aGraph, aLinkerContext, theOptimizer);
        }
    }
    ,
    LLVM{

        @Override
        public void optimize(ControlFlowGraph aGraph, BytecodeLinkerContext aLinkerContext) {
            ArrayList<SinglePassOptimizer> theOptimizer = new ArrayList<SinglePassOptimizer>();
            theOptimizer.add(new SinglePassOptimizer(new OptimizerStage[]{new InvokeVirtualOptimizerStage(), new InefficientCompareOptimizerStage()}));
            KnownOptimizer.run(aGraph, aLinkerContext, theOptimizer);
        }
    };


    private static void run(ControlFlowGraph aGraph, BytecodeLinkerContext aLinkerContext, List<Optimizer> aList) {
        try {
            for (Optimizer theOptimizer : aList) {
                theOptimizer.optimize(aGraph, aLinkerContext);
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error optimizing cfg : " + aGraph.toDOT(), e);
        }
    }
}

