/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.optimizer;

import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.Statistics;
import de.mirkosertic.bytecoder.optimizer.OptimizerStage;
import de.mirkosertic.bytecoder.ssa.ClassHierarchyAnalysis;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import de.mirkosertic.bytecoder.ssa.DirectInvokeMethodExpression;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.InvokeVirtualMethodExpression;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;
import java.util.Optional;

public class InvokeVirtualOptimizerStage
implements OptimizerStage {
    @Override
    public Expression optimize(ControlFlowGraph aGraph, BytecodeLinkerContext aLinkerContext, RegionNode aCurrentNode, ExpressionList aExpressionList, Expression aExpression) {
        if (aExpression instanceof InvokeVirtualMethodExpression) {
            return this.visit(aExpressionList, (InvokeVirtualMethodExpression)aExpression, aLinkerContext);
        }
        if (aExpression instanceof VariableAssignmentExpression) {
            return this.visit((VariableAssignmentExpression)aExpression, aLinkerContext);
        }
        return aExpression;
    }

    private Expression visit(VariableAssignmentExpression aExpression, BytecodeLinkerContext aLinkerContext) {
        Value theValue = (Value)aExpression.incomingDataFlows().get(0);
        if (theValue instanceof InvokeVirtualMethodExpression) {
            Optional<DirectInvokeMethodExpression> theNewExpression = this.visit((InvokeVirtualMethodExpression)theValue, aLinkerContext);
            theNewExpression.ifPresent(directInvokeMethodExpression -> aExpression.replaceIncomingDataEdge(theValue, (Value)directInvokeMethodExpression));
        }
        return aExpression;
    }

    private Expression visit(ExpressionList aExpressions, InvokeVirtualMethodExpression aExpression, BytecodeLinkerContext aLinkerContext) {
        Optional<DirectInvokeMethodExpression> theNewExpression = this.visit(aExpression, aLinkerContext);
        if (theNewExpression.isPresent()) {
            Expression theNew = theNewExpression.get();
            aExpressions.replace((Expression)aExpression, theNew);
            return theNew;
        }
        return aExpression;
    }

    private Optional<DirectInvokeMethodExpression> visit(InvokeVirtualMethodExpression aExpression, BytecodeLinkerContext aLinkerContext) {
        if (aExpression.isInterfaceInvocation()) {
            return Optional.empty();
        }
        Statistics.Context context = aLinkerContext.getStatistics().context("InvokeVirtualOptimizer");
        context.counter("Total number of invocations").increment();
        String theMethodName = aExpression.getMethodName();
        BytecodeMethodSignature theSignature = aExpression.getSignature();
        ClassHierarchyAnalysis theAnalysis = new ClassHierarchyAnalysis(aLinkerContext);
        Optional<BytecodeLinkedClass> theClassToInvoke = theAnalysis.classProvidingInvokableMethod(theMethodName, theSignature, aExpression.getInvokedClass(), (Value)aExpression.incomingDataFlows().get(0), aClass -> !aClass.emulatedByRuntime() && !aClass.getClassName().name().equals(Class.class.getName()), aMethod -> !aMethod.getAccessFlags().isAbstract() && !aMethod.getAccessFlags().isStatic());
        if (theClassToInvoke.isPresent()) {
            BytecodeLinkedClass theLinked = theClassToInvoke.get();
            BytecodeObjectTypeRef theClazz = theLinked.getClassName();
            BytecodeMethod theMethodToInvoke = theLinked.getBytecodeClass().methodByNameAndSignatureOrNull(theMethodName, theSignature);
            DirectInvokeMethodExpression theNewExpression = new DirectInvokeMethodExpression(aExpression.getProgram(), aExpression.getAddress(), theClazz, theMethodToInvoke.getName().stringValue(), theSignature);
            aExpression.routeIncomingDataFlowsTo(theNewExpression);
            context.counter("Optimized invocations").increment();
            return Optional.of(theNewExpression);
        }
        return Optional.empty();
    }
}

