/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.optimizer;

import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.optimizer.Optimizer;
import de.mirkosertic.bytecoder.optimizer.OptimizerStage;
import de.mirkosertic.bytecoder.optimizer.SinglePassOptimizer;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;
import java.util.HashMap;
import java.util.List;

public class InlineMethodParameterOptimizer
implements Optimizer {
    @Override
    public void optimize(ControlFlowGraph aGraph, BytecodeLinkerContext aLinkerContext) {
        Program theProgram = aGraph.getProgram();
        HashMap<Variable, Value> theOnceInitialized = new HashMap<Variable, Value>();
        for (Variable v : theProgram.getVariables()) {
            Value theSingleValue;
            List theIncoming;
            if (v.isSynthetic() || (theIncoming = v.incomingDataFlows()).size() != 1 || !((theSingleValue = (Value)theIncoming.get(0)) instanceof Variable) || !((Variable)theSingleValue).isSynthetic()) continue;
            theOnceInitialized.put(v, theSingleValue);
        }
        if (!theOnceInitialized.isEmpty()) {
            SinglePassOptimizer theSinglePass = new SinglePassOptimizer(new OptimizerStage[]{(aGraph1, aLinkerContext1, aCurrentNode, aExpressionList, aExpression) -> {
                Value theReplacement;
                VariableAssignmentExpression theVarAssign;
                Value theValue;
                if (aExpression instanceof VariableAssignmentExpression && (theValue = (Value)(theVarAssign = (VariableAssignmentExpression)aExpression).incomingDataFlows().get(0)) instanceof Variable && (theReplacement = (Value)theOnceInitialized.get(theValue)) != null) {
                    theVarAssign.replaceIncomingDataEdge(theValue, theReplacement);
                }
                return aExpression;
            }});
            theSinglePass.optimize(aGraph, aLinkerContext);
        }
    }
}

