/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.optimizer;

import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.optimizer.Optimizer;
import de.mirkosertic.bytecoder.optimizer.OptimizerStage;
import de.mirkosertic.bytecoder.optimizer.SinglePassOptimizer;
import de.mirkosertic.bytecoder.ssa.BlockState;
import de.mirkosertic.bytecoder.ssa.Constant;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class InlineConstVariablesOptimizer
implements Optimizer {
    @Override
    public void optimize(ControlFlowGraph aGraph, BytecodeLinkerContext aLinkerContext) {
        Program theProgram = aGraph.getProgram();
        HashMap<Variable, Value> theConstantMappings = new HashMap<Variable, Value>();
        HashSet<Value> theLiveOuts = new HashSet<Value>();
        for (RegionNode n : theProgram.getControlFlowGraph().dominators().getPreOrder()) {
            BlockState theLiveout = n.liveOut();
            theLiveOuts.addAll(theLiveout.getPorts().values());
        }
        for (Variable v : theProgram.getVariables()) {
            Value theSingleValue;
            List theIncoming;
            if (v.isSynthetic() || theLiveOuts.contains(v) || (theIncoming = v.incomingDataFlows()).size() != 1 || !((theSingleValue = (Value)theIncoming.get(0)) instanceof Constant) && (!(theSingleValue instanceof Variable) || !((Variable)theSingleValue).isSynthetic())) continue;
            theConstantMappings.put(v, theSingleValue);
            v.outgoingEdges().map(t -> (Value)t.targetNode()).forEach(t -> t.replaceIncomingDataEdge(v, theSingleValue));
        }
        if (!theConstantMappings.isEmpty()) {
            SinglePassOptimizer theSinglePass = new SinglePassOptimizer(new OptimizerStage[]{(aGraph1, aLinkerContext1, aCurrentNode, aExpressionList, aExpression) -> {
                VariableAssignmentExpression theVarAssign;
                if (aExpression instanceof VariableAssignmentExpression && theConstantMappings.containsKey((theVarAssign = (VariableAssignmentExpression)aExpression).getVariable())) {
                    aExpressionList.remove(aExpression);
                }
                return aExpression;
            }});
            theSinglePass.optimize(aGraph, aLinkerContext);
            for (Variable v : theConstantMappings.keySet()) {
                theProgram.deleteVariable(v);
            }
        }
    }
}

