/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.optimizer;

import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.optimizer.OptimizerStage;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.IFElseExpression;
import de.mirkosertic.bytecoder.ssa.IFExpression;
import de.mirkosertic.bytecoder.ssa.InvocationExpression;
import de.mirkosertic.bytecoder.ssa.PutStaticExpression;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.ReturnValueExpression;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;
import java.util.List;
import java.util.stream.Collectors;

public class InlineCallArgumentsOptimizerStage
implements OptimizerStage {
    @Override
    public Expression optimize(ControlFlowGraph aGraph, BytecodeLinkerContext aLinkerContext, RegionNode aCurrentNode, ExpressionList aExpressionList, Expression aExpression) {
        Value theValueToObserve = null;
        if (aExpression instanceof InvocationExpression) {
            theValueToObserve = aExpression;
        } else if (aExpression instanceof VariableAssignmentExpression) {
            VariableAssignmentExpression theAssignment = (VariableAssignmentExpression)aExpression;
            Value theValue = (Value)theAssignment.incomingDataFlows().get(0);
            if (theValue instanceof InvocationExpression) {
                theValueToObserve = theValue;
            } else {
                List theIncoming = theValue.incomingDataFlows();
                if (theIncoming.size() > 0 && theIncoming.get(0) instanceof InvocationExpression) {
                    theValueToObserve = (Value)theIncoming.get(0);
                }
            }
        } else if (aExpression instanceof IFExpression) {
            theValueToObserve = (Value)aExpression.incomingDataFlows().get(0);
        } else if (aExpression instanceof IFElseExpression) {
            theValueToObserve = (Value)aExpression.incomingDataFlows().get(0);
        } else if (aExpression instanceof ReturnValueExpression) {
            theValueToObserve = aExpression;
        } else if (aExpression instanceof PutStaticExpression) {
            theValueToObserve = aExpression;
        }
        if (theValueToObserve != null) {
            Expression theBefore;
            List theVars = theValueToObserve.incomingDataFlows().stream().filter(t -> t instanceof Variable).map(t -> (Variable)t).collect(Collectors.toList());
            while (!theVars.isEmpty() && (theBefore = aExpressionList.predecessorOf(aExpression)) instanceof VariableAssignmentExpression) {
                VariableAssignmentExpression theBeforeAss = (VariableAssignmentExpression)theBefore;
                Variable theVar = theBeforeAss.getVariable();
                if (aCurrentNode.liveOut().contains(theVar) || theVar != theVars.get(theVars.size() - 1) || theVar.outgoingEdges().count() != 1L) break;
                theValueToObserve.replaceIncomingDataEdge(theVar, (Value)theBeforeAss.incomingDataFlows().get(0));
                aExpressionList.remove(theBeforeAss);
                aGraph.getProgram().deleteVariable(theVar);
                theVars.remove(theVar);
            }
        }
        return aExpression;
    }
}

