/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.optimizer;

import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.graph.Edge;
import de.mirkosertic.bytecoder.optimizer.OptimizerStage;
import de.mirkosertic.bytecoder.ssa.BinaryExpression;
import de.mirkosertic.bytecoder.ssa.BlockState;
import de.mirkosertic.bytecoder.ssa.CompareExpression;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import de.mirkosertic.bytecoder.ssa.DataFlowEdgeType;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.FixedBinaryExpression;
import de.mirkosertic.bytecoder.ssa.IFExpression;
import de.mirkosertic.bytecoder.ssa.IntegerValue;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;
import java.util.List;
import java.util.stream.Collectors;

public class InefficientCompareOptimizerStage
implements OptimizerStage {
    @Override
    public Expression optimize(ControlFlowGraph aGraph, BytecodeLinkerContext aLinkerContext, RegionNode aCurrentNode, ExpressionList aExpressionList, Expression aExpression) {
        if (aExpression instanceof IFExpression) {
            Value theFirst;
            Expression theBinary;
            IFExpression theIf = (IFExpression)aExpression;
            Value theCondition = (Value)theIf.incomingDataFlows().get(0);
            if (theCondition instanceof FixedBinaryExpression) {
                theBinary = (FixedBinaryExpression)theCondition;
                theFirst = (Value)theBinary.incomingDataFlows().get(0);
                Expression theBefore = aExpressionList.predecessorOf(aExpression);
                if (theBefore instanceof VariableAssignmentExpression) {
                    VariableAssignmentExpression theAssignment = (VariableAssignmentExpression)theBefore;
                    Variable theVariable = theAssignment.getVariable();
                    List theDataEdges = theVariable.outgoingEdges(DataFlowEdgeType.filter()).collect(Collectors.toList());
                    BlockState theLiveOut = aCurrentNode.liveOut();
                    if (theDataEdges.size() == 1 && theFirst == ((Edge)theDataEdges.get(0)).sourceNode() && !theLiveOut.contains(theVariable)) {
                        aExpressionList.remove(theAssignment);
                        theBinary.replaceIncomingDataEdge(theVariable, (Value)theAssignment.incomingDataFlows().get(0));
                        aGraph.getProgram().deleteVariable(theVariable);
                        return aExpression;
                    }
                }
            }
            if (theCondition instanceof BinaryExpression) {
                Value theValue;
                VariableAssignmentExpression theAssignment;
                Variable theVariable;
                List theDataEdges;
                Expression theBefore;
                theBinary = (BinaryExpression)theCondition;
                theFirst = (Value)theBinary.incomingDataFlows().get(0);
                Value theSecond = (Value)theBinary.incomingDataFlows().get(1);
                if (theSecond instanceof IntegerValue && (theBefore = aExpressionList.predecessorOf(aExpression)) instanceof VariableAssignmentExpression && (theDataEdges = (theVariable = (theAssignment = (VariableAssignmentExpression)theBefore).getVariable()).outgoingEdges(DataFlowEdgeType.filter()).collect(Collectors.toList())).size() == 1 && theFirst == theVariable && (theValue = (Value)theAssignment.incomingDataFlows().get(0)) instanceof CompareExpression) {
                    CompareExpression theCompare = (CompareExpression)theValue;
                    Value theA = (Value)theCompare.incomingDataFlows().get(0);
                    Value theB = (Value)theCompare.incomingDataFlows().get(1);
                    IntegerValue theIntegerValue = (IntegerValue)theSecond;
                    if (theIntegerValue.getIntValue() == 0) {
                        switch (((BinaryExpression)theBinary).getOperator()) {
                            case GREATEROREQUALS: {
                                BinaryExpression theNewCondition = new BinaryExpression(theAssignment.getProgram(), theAssignment.getAddress(), theCompare.resolveType(), theA, BinaryExpression.Operator.GREATEROREQUALS, theB);
                                theIf.replaceIncomingDataEdge(theCondition, theNewCondition);
                                aExpressionList.remove(theAssignment);
                                aGraph.getProgram().deleteVariable(theVariable);
                                return aExpression;
                            }
                            case GREATERTHAN: {
                                BinaryExpression theNewCondition = new BinaryExpression(theAssignment.getProgram(), theAssignment.getAddress(), theCompare.resolveType(), theA, BinaryExpression.Operator.GREATERTHAN, theB);
                                theIf.replaceIncomingDataEdge(theCondition, theNewCondition);
                                aExpressionList.remove(theAssignment);
                                aGraph.getProgram().deleteVariable(theVariable);
                                return aExpression;
                            }
                            case LESSTHANOREQUALS: {
                                BinaryExpression theNewCondition = new BinaryExpression(theAssignment.getProgram(), theAssignment.getAddress(), theCompare.resolveType(), theA, BinaryExpression.Operator.LESSTHANOREQUALS, theB);
                                theIf.replaceIncomingDataEdge(theCondition, theNewCondition);
                                aExpressionList.remove(theAssignment);
                                aGraph.getProgram().deleteVariable(theVariable);
                                return aExpression;
                            }
                            case LESSTHAN: {
                                BinaryExpression theNewCondition = new BinaryExpression(theAssignment.getProgram(), theAssignment.getAddress(), theCompare.resolveType(), theA, BinaryExpression.Operator.LESSTHAN, theB);
                                theIf.replaceIncomingDataEdge(theCondition, theNewCondition);
                                aExpressionList.remove(theAssignment);
                                aGraph.getProgram().deleteVariable(theVariable);
                                return aExpression;
                            }
                            case EQUALS: {
                                BinaryExpression theNewCondition = new BinaryExpression(theAssignment.getProgram(), theAssignment.getAddress(), theCompare.resolveType(), theA, BinaryExpression.Operator.EQUALS, theB);
                                theIf.replaceIncomingDataEdge(theCondition, theNewCondition);
                                aExpressionList.remove(theAssignment);
                                aGraph.getProgram().deleteVariable(theVariable);
                                return aExpression;
                            }
                            case NOTEQUALS: {
                                BinaryExpression theNewCondition = new BinaryExpression(theAssignment.getProgram(), theAssignment.getAddress(), theCompare.resolveType(), theA, BinaryExpression.Operator.NOTEQUALS, theB);
                                theIf.replaceIncomingDataEdge(theCondition, theNewCondition);
                                aExpressionList.remove(theAssignment);
                                aGraph.getProgram().deleteVariable(theVariable);
                                return aExpression;
                            }
                        }
                    }
                }
            }
        }
        return aExpression;
    }
}

