/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.optimizer;

import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.optimizer.OptimizerStage;
import de.mirkosertic.bytecoder.ssa.BinaryExpression;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;

public class BinaryExpressionOptimizerStage
implements OptimizerStage {
    private boolean isRegularVariable(Value value) {
        return value instanceof Variable && !((Variable)value).isSynthetic();
    }

    @Override
    public Expression optimize(ControlFlowGraph aGraph, BytecodeLinkerContext aLinkerContext, RegionNode aCurrentNode, ExpressionList aExpressionList, Expression aExpression) {
        VariableAssignmentExpression theAssignment;
        Value theAssignedValue;
        while (aExpression instanceof VariableAssignmentExpression && (theAssignedValue = (Value)(theAssignment = (VariableAssignmentExpression)aExpression).incomingDataFlows().get(0)) instanceof BinaryExpression) {
            Value theValue1 = (Value)theAssignedValue.incomingDataFlows().get(0);
            Value theValue2 = (Value)theAssignedValue.incomingDataFlows().get(1);
            Expression theBefore = aExpressionList.predecessorOf(aExpression);
            if (!(theBefore instanceof VariableAssignmentExpression)) break;
            VariableAssignmentExpression theBeforeAssignment = (VariableAssignmentExpression)theBefore;
            if (theBeforeAssignment.getVariable() == theValue1 && this.isRegularVariable(theValue1) && theBeforeAssignment.getVariable().outgoingEdges().count() == 1L && !aCurrentNode.liveOut().contains(theBeforeAssignment.getVariable())) {
                theAssignedValue.replaceIncomingDataEdge(theValue1, (Value)theBeforeAssignment.incomingDataFlows().get(0));
                aGraph.getProgram().deleteVariable(theBeforeAssignment.getVariable());
                aExpressionList.remove(theBeforeAssignment);
                continue;
            }
            if (theBeforeAssignment.getVariable() != theValue2 || !this.isRegularVariable(theValue2) || theBeforeAssignment.getVariable().outgoingEdges().count() != 1L || aCurrentNode.liveOut().contains(theBeforeAssignment.getVariable())) break;
            theAssignedValue.replaceIncomingDataEdge(theValue2, (Value)theBeforeAssignment.incomingDataFlows().get(0));
            aGraph.getProgram().deleteVariable(theBeforeAssignment.getVariable());
            aExpressionList.remove(theBeforeAssignment);
        }
        return aExpression;
    }
}

