/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.optimizer;

import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.optimizer.OptimizerStage;
import de.mirkosertic.bytecoder.ssa.ArrayLengthExpression;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;

public class ArrayReadLengthOptimizerStage
implements OptimizerStage {
    private boolean isRegularVariable(Value value) {
        return value instanceof Variable && !((Variable)value).isSynthetic();
    }

    @Override
    public Expression optimize(ControlFlowGraph aGraph, BytecodeLinkerContext aLinkerContext, RegionNode aCurrentNode, ExpressionList aExpressionList, Expression aExpression) {
        VariableAssignmentExpression theBeforeAssignment;
        Expression theBefore;
        Value theArray;
        VariableAssignmentExpression theAssignment;
        Value theValue;
        if (aExpression instanceof VariableAssignmentExpression && (theValue = (Value)(theAssignment = (VariableAssignmentExpression)aExpression).incomingDataFlows().get(0)) instanceof ArrayLengthExpression && this.isRegularVariable(theArray = (Value)theValue.incomingDataFlows().get(0)) && (theBefore = aExpressionList.predecessorOf(aExpression)) instanceof VariableAssignmentExpression && (theBeforeAssignment = (VariableAssignmentExpression)theBefore).getVariable() == theArray && theArray.outgoingEdges().count() == 1L && !aCurrentNode.liveOut().contains(theBeforeAssignment.getVariable())) {
            theValue.replaceIncomingDataEdge(theArray, (Value)theBeforeAssignment.incomingDataFlows().get(0));
            aGraph.getProgram().deleteVariable(theBeforeAssignment.getVariable());
            aExpressionList.remove(theBeforeAssignment);
            return aExpression;
        }
        return aExpression;
    }
}

