/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.optimizer;

import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.optimizer.OptimizerStage;
import de.mirkosertic.bytecoder.ssa.ArrayStoreExpression;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;

public class ArrayEntryWriteOptimizerStage
implements OptimizerStage {
    private boolean isRegularVariable(Value value) {
        return value instanceof Variable && !((Variable)value).isSynthetic();
    }

    @Override
    public Expression optimize(ControlFlowGraph aGraph, BytecodeLinkerContext aLinkerContext, RegionNode aCurrentNode, ExpressionList aExpressionList, Expression aExpression) {
        while (aExpression instanceof ArrayStoreExpression) {
            ArrayStoreExpression theExpression = (ArrayStoreExpression)aExpression;
            Value theArray = (Value)theExpression.incomingDataFlows().get(0);
            Value theIndex = (Value)theExpression.incomingDataFlows().get(1);
            Value theValue = (Value)theExpression.incomingDataFlows().get(2);
            Expression theBefore = aExpressionList.predecessorOf(aExpression);
            if (!(theBefore instanceof VariableAssignmentExpression)) break;
            VariableAssignmentExpression theBeforeAssignment = (VariableAssignmentExpression)theBefore;
            if (theBeforeAssignment.getVariable() == theIndex && this.isRegularVariable(theIndex) && theIndex.outgoingEdges().count() == 1L && !aCurrentNode.liveOut().contains(theBeforeAssignment.getVariable())) {
                theExpression.replaceIncomingDataEdge(theIndex, (Value)theBeforeAssignment.incomingDataFlows().get(0));
                aGraph.getProgram().deleteVariable(theBeforeAssignment.getVariable());
                aExpressionList.remove(theBeforeAssignment);
                continue;
            }
            if (theBeforeAssignment.getVariable() == theArray && this.isRegularVariable(theArray) && theArray.outgoingEdges().count() == 1L && !aCurrentNode.liveOut().contains(theBeforeAssignment.getVariable())) {
                theExpression.replaceIncomingDataEdge(theArray, (Value)theBeforeAssignment.incomingDataFlows().get(0));
                aGraph.getProgram().deleteVariable(theBeforeAssignment.getVariable());
                aExpressionList.remove(theBeforeAssignment);
                continue;
            }
            if (theBeforeAssignment.getVariable() != theValue || !this.isRegularVariable(theValue) || theValue.outgoingEdges().count() != 1L || aCurrentNode.liveOut().contains(theBeforeAssignment.getVariable())) break;
            theExpression.replaceIncomingDataEdge(theValue, (Value)theBeforeAssignment.incomingDataFlows().get(0));
            aGraph.getProgram().deleteVariable(theBeforeAssignment.getVariable());
            aExpressionList.remove(theBeforeAssignment);
        }
        return aExpression;
    }
}

