/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.intrinsics;

import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKESTATIC;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.intrinsics.Intrinsic;
import de.mirkosertic.bytecoder.ssa.ArrayEntryExpression;
import de.mirkosertic.bytecoder.ssa.ArrayLengthExpression;
import de.mirkosertic.bytecoder.ssa.ArrayStoreExpression;
import de.mirkosertic.bytecoder.ssa.NewArrayExpression;
import de.mirkosertic.bytecoder.ssa.ParsingHelper;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import java.lang.reflect.Array;
import java.util.List;

public class JavaUtilArrayIntrinsic
extends Intrinsic {
    @Override
    public boolean intrinsify(Program aProgram, BytecodeInstructionINVOKESTATIC aInstruction, String aMethodName, List<Value> aArguments, BytecodeObjectTypeRef aTargetClass, RegionNode aTargetBlock, ParsingHelper aHelper) {
        if (Array.class.getName().equals(aTargetClass.name())) {
            if ("newInstance".equals(aMethodName)) {
                Value theArrayType = aArguments.get(0);
                Value theArraySize = aArguments.get(1);
                NewArrayExpression theValue = new NewArrayExpression(aProgram, aInstruction.getOpcodeAddress(), BytecodeObjectTypeRef.fromRuntimeClass(Object.class), theArraySize);
                Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.toType(aInstruction.getMethodReference().getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature().getReturnType()), theValue);
                aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
                return true;
            }
            if ("getLength".equals(aMethodName)) {
                Value theArray = aArguments.get(0);
                ArrayLengthExpression theValue = new ArrayLengthExpression(aProgram, aInstruction.getOpcodeAddress(), theArray);
                Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.Native.INT, theValue);
                aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
                return true;
            }
            if ("setBoolean".equals(aMethodName)) {
                Value theArray = aArguments.get(0);
                Value theIndex = aArguments.get(1);
                Value theValue = aArguments.get(2);
                aTargetBlock.getExpressions().add(new ArrayStoreExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.Native.BOOLEAN, theArray, theIndex, theValue));
                return true;
            }
            if ("getBoolean".equals(aMethodName)) {
                Value theArray = aArguments.get(0);
                Value theIndex = aArguments.get(1);
                ArrayEntryExpression theValue = new ArrayEntryExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.Native.BOOLEAN, theArray, theIndex);
                Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.Native.BOOLEAN, theValue);
                aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
                return true;
            }
            if ("setByte".equals(aMethodName)) {
                Value theArray = aArguments.get(0);
                Value theIndex = aArguments.get(1);
                Value theValue = aArguments.get(2);
                aTargetBlock.getExpressions().add(new ArrayStoreExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.Native.BYTE, theArray, theIndex, theValue));
                return true;
            }
            if ("getByte".equals(aMethodName)) {
                Value theArray = aArguments.get(0);
                Value theIndex = aArguments.get(1);
                ArrayEntryExpression theValue = new ArrayEntryExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.Native.BYTE, theArray, theIndex);
                Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.Native.BYTE, theValue);
                aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
                return true;
            }
            if ("setChar".equals(aMethodName)) {
                Value theArray = aArguments.get(0);
                Value theIndex = aArguments.get(1);
                Value theValue = aArguments.get(2);
                aTargetBlock.getExpressions().add(new ArrayStoreExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.Native.CHAR, theArray, theIndex, theValue));
                return true;
            }
            if ("getChar".equals(aMethodName)) {
                Value theArray = aArguments.get(0);
                Value theIndex = aArguments.get(1);
                ArrayEntryExpression theValue = new ArrayEntryExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.Native.CHAR, theArray, theIndex);
                Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.Native.CHAR, theValue);
                aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
                return true;
            }
            if ("setDouble".equals(aMethodName)) {
                Value theArray = aArguments.get(0);
                Value theIndex = aArguments.get(1);
                Value theValue = aArguments.get(2);
                aTargetBlock.getExpressions().add(new ArrayStoreExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.Native.DOUBLE, theArray, theIndex, theValue));
                return true;
            }
            if ("getDouble".equals(aMethodName)) {
                Value theArray = aArguments.get(0);
                Value theIndex = aArguments.get(1);
                ArrayEntryExpression theValue = new ArrayEntryExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.Native.DOUBLE, theArray, theIndex);
                Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.Native.DOUBLE, theValue);
                aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
                return true;
            }
            if ("setFloat".equals(aMethodName)) {
                Value theArray = aArguments.get(0);
                Value theIndex = aArguments.get(1);
                Value theValue = aArguments.get(2);
                aTargetBlock.getExpressions().add(new ArrayStoreExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.Native.FLOAT, theArray, theIndex, theValue));
                return true;
            }
            if ("getFloat".equals(aMethodName)) {
                Value theArray = aArguments.get(0);
                Value theIndex = aArguments.get(1);
                ArrayEntryExpression theValue = new ArrayEntryExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.Native.FLOAT, theArray, theIndex);
                Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.Native.FLOAT, theValue);
                aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
                return true;
            }
            if ("setInt".equals(aMethodName)) {
                Value theArray = aArguments.get(0);
                Value theIndex = aArguments.get(1);
                Value theValue = aArguments.get(2);
                aTargetBlock.getExpressions().add(new ArrayStoreExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.Native.INT, theArray, theIndex, theValue));
                return true;
            }
            if ("getInt".equals(aMethodName)) {
                Value theArray = aArguments.get(0);
                Value theIndex = aArguments.get(1);
                ArrayEntryExpression theValue = new ArrayEntryExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.Native.INT, theArray, theIndex);
                Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.Native.INT, theValue);
                aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
                return true;
            }
            if ("setLong".equals(aMethodName)) {
                Value theArray = aArguments.get(0);
                Value theIndex = aArguments.get(1);
                Value theValue = aArguments.get(2);
                aTargetBlock.getExpressions().add(new ArrayStoreExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.Native.LONG, theArray, theIndex, theValue));
                return true;
            }
            if ("getLong".equals(aMethodName)) {
                Value theArray = aArguments.get(0);
                Value theIndex = aArguments.get(1);
                ArrayEntryExpression theValue = new ArrayEntryExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.Native.LONG, theArray, theIndex);
                Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.Native.LONG, theValue);
                aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
                return true;
            }
            if ("setShort".equals(aMethodName)) {
                Value theArray = aArguments.get(0);
                Value theIndex = aArguments.get(1);
                Value theValue = aArguments.get(2);
                aTargetBlock.getExpressions().add(new ArrayStoreExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.Native.SHORT, theArray, theIndex, theValue));
                return true;
            }
            if ("getShort".equals(aMethodName)) {
                Value theArray = aArguments.get(0);
                Value theIndex = aArguments.get(1);
                ArrayEntryExpression theValue = new ArrayEntryExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.Native.SHORT, theArray, theIndex);
                Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.Native.SHORT, theValue);
                aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
                return true;
            }
            if ("set".equals(aMethodName)) {
                Value theArray = aArguments.get(0);
                Value theIndex = aArguments.get(1);
                Value theValue = aArguments.get(2);
                aTargetBlock.getExpressions().add(new ArrayStoreExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.toType(BytecodeObjectTypeRef.fromRuntimeClass(Object.class)), theArray, theIndex, theValue));
                return true;
            }
            if ("get".equals(aMethodName)) {
                Value theArray = aArguments.get(0);
                Value theIndex = aArguments.get(1);
                ArrayEntryExpression theValue = new ArrayEntryExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.toType(BytecodeObjectTypeRef.fromRuntimeClass(Object.class)), theArray, theIndex);
                Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.toType(BytecodeObjectTypeRef.fromRuntimeClass(Object.class)), theValue);
                aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
                return true;
            }
            if ("newArray".equals(aMethodName)) {
                Value theType = aArguments.get(0);
                Value theLength = aArguments.get(1);
                Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, new NewArrayExpression(aProgram, aInstruction.getOpcodeAddress(), BytecodeObjectTypeRef.fromRuntimeClass(Object.class), theLength));
                aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
                return true;
            }
        }
        return false;
    }
}

