/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.intrinsics;

import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKESTATIC;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.intrinsics.Intrinsic;
import de.mirkosertic.bytecoder.ssa.FloatingPointCeilExpression;
import de.mirkosertic.bytecoder.ssa.FloatingPointFloorExpression;
import de.mirkosertic.bytecoder.ssa.MaxExpression;
import de.mirkosertic.bytecoder.ssa.MinExpression;
import de.mirkosertic.bytecoder.ssa.ParsingHelper;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.SqrtExpression;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import java.util.List;

public class JavaLangMathIntrinsic
extends Intrinsic {
    @Override
    public boolean intrinsify(Program aProgram, BytecodeInstructionINVOKESTATIC aInstruction, String aMethodName, List<Value> aArguments, BytecodeObjectTypeRef aTargetClass, RegionNode aTargetBlock, ParsingHelper aHelper) {
        if (Math.class.getName().equals(aTargetClass.name())) {
            BytecodeMethodSignature theSignature = aInstruction.getMethodReference().getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature();
            if ("sqrt".equals(aMethodName)) {
                SqrtExpression theValue = new SqrtExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.toType(theSignature.getReturnType()), aArguments.get(0));
                Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.toType(theSignature.getReturnType()), theValue);
                aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
                return true;
            }
            if ("floor".equals(aMethodName)) {
                FloatingPointFloorExpression theValue = new FloatingPointFloorExpression(aProgram, aInstruction.getOpcodeAddress(), aArguments.get(0), TypeRef.toType(theSignature.getReturnType()));
                Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.toType(theSignature.getReturnType()), theValue);
                aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
                return true;
            }
            if ("ceil".equals(aMethodName)) {
                FloatingPointCeilExpression theValue = new FloatingPointCeilExpression(aProgram, aInstruction.getOpcodeAddress(), aArguments.get(0), TypeRef.toType(theSignature.getReturnType()));
                Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.toType(theSignature.getReturnType()), theValue);
                aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
                return true;
            }
            if ("min".equals(aMethodName)) {
                MinExpression theValue = new MinExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.toType(theSignature.getReturnType()), aArguments.get(0), aArguments.get(1));
                Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.toType(theSignature.getReturnType()), theValue);
                aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
                return true;
            }
            if ("max".equals(aMethodName)) {
                MaxExpression theValue = new MaxExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.toType(theSignature.getReturnType()), aArguments.get(0), aArguments.get(1));
                Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.toType(theSignature.getReturnType()), theValue);
                aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
                return true;
            }
        }
        return false;
    }
}

