/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.intrinsics;

import de.mirkosertic.bytecoder.core.BytecodeInstructionGETSTATIC;
import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKEVIRTUAL;
import de.mirkosertic.bytecoder.core.BytecodeInstructionPUTSTATIC;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.intrinsics.Intrinsic;
import de.mirkosertic.bytecoder.ssa.ClassReferenceValue;
import de.mirkosertic.bytecoder.ssa.EnumConstantsExpression;
import de.mirkosertic.bytecoder.ssa.ParsingHelper;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.SetEnumConstantsExpression;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import java.util.List;

public class JavaLangEnumIntrinsic
extends Intrinsic {
    @Override
    public boolean intrinsify(Program aProgram, BytecodeInstructionINVOKEVIRTUAL aInstruction, String aMethodName, List<Value> aArguments, Value aTarget, RegionNode aTargetBlock, ParsingHelper aHelper) {
        BytecodeMethodSignature theSignature = aInstruction.getMethodReference().getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature();
        if ("getEnumConstants".equals(aMethodName) && theSignature.matchesExactlyTo(BytecodeLinkedClass.GET_ENUM_CONSTANTS_SIGNATURE)) {
            EnumConstantsExpression theValue = new EnumConstantsExpression(aProgram, aInstruction.getOpcodeAddress(), aTarget);
            Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.toType(theSignature.getReturnType()), theValue);
            aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
            return true;
        }
        return false;
    }

    @Override
    public boolean intrinsify(Program aProgram, BytecodeInstructionGETSTATIC aInstruction, String aFieldName, BytecodeObjectTypeRef aTtargetType, RegionNode aTargetBlock, ParsingHelper aHelper) {
        if ("$VALUES".equals(aFieldName)) {
            EnumConstantsExpression theValue = new EnumConstantsExpression(aProgram, aInstruction.getOpcodeAddress(), new ClassReferenceValue(aTtargetType));
            aHelper.push(aInstruction.getOpcodeAddress(), theValue);
            return true;
        }
        return false;
    }

    @Override
    public boolean intrinsify(Program aProgram, BytecodeInstructionPUTSTATIC aInstruction, String aFieldName, BytecodeObjectTypeRef aTtargetType, Value aValue, RegionNode aTargetBlock, ParsingHelper aHelper) {
        if ("$VALUES".equals(aFieldName)) {
            aTargetBlock.getExpressions().add(new SetEnumConstantsExpression(aProgram, aInstruction.getOpcodeAddress(), new ClassReferenceValue(aTtargetType), aValue));
            return true;
        }
        return false;
    }
}

