/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.intrinsics;

import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKESTATIC;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.intrinsics.Intrinsic;
import de.mirkosertic.bytecoder.ssa.IsNaNExpression;
import de.mirkosertic.bytecoder.ssa.ParsingHelper;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import java.util.List;

public class JavaLangDoubleIntrinsic
extends Intrinsic {
    @Override
    public boolean intrinsify(Program aProgram, BytecodeInstructionINVOKESTATIC aInstruction, String aMethodName, List<Value> aArguments, BytecodeObjectTypeRef aTargetClass, RegionNode aTargetBlock, ParsingHelper aHelper) {
        if (Double.class.getName().equals(aTargetClass.name())) {
            BytecodeMethodSignature theSignature = aInstruction.getMethodReference().getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature();
            if ("isNaN".equals(aMethodName)) {
                IsNaNExpression theValue = new IsNaNExpression(aProgram, aInstruction.getOpcodeAddress(), TypeRef.Native.DOUBLE, aArguments.get(0));
                Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.toType(theSignature.getReturnType()), theValue);
                aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
                return true;
            }
        }
        return false;
    }
}

