/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.intrinsics;

import de.mirkosertic.bytecoder.core.BytecodeInstructionGETSTATIC;
import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKESPECIAL;
import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKESTATIC;
import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKEVIRTUAL;
import de.mirkosertic.bytecoder.core.BytecodeInstructionPUTSTATIC;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.intrinsics.Intrinsic;
import de.mirkosertic.bytecoder.ssa.IntegerValue;
import de.mirkosertic.bytecoder.ssa.NewInstanceFromDefaultConstructorExpression;
import de.mirkosertic.bytecoder.ssa.ParsingHelper;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.StringValue;
import de.mirkosertic.bytecoder.ssa.SuperTypeOfExpression;
import de.mirkosertic.bytecoder.ssa.TypeOfExpression;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import java.util.List;

public class JavaLangClassIntrinsic
extends Intrinsic {
    @Override
    public boolean intrinsify(Program aProgram, BytecodeInstructionINVOKESPECIAL aInstruction, String aMethodName, BytecodeObjectTypeRef aType, List<Value> aArguments, Variable aTarget, RegionNode aTargetBlock, ParsingHelper aHelper) {
        BytecodeMethodSignature theSignature = aInstruction.getMethodReference().getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature();
        BytecodeObjectTypeRef theCalledClass = BytecodeObjectTypeRef.fromUtf8Constant(aInstruction.getMethodReference().getClassIndex().getClassConstant().getConstant());
        if ("getClass".equals(aMethodName) && BytecodeLinkedClass.GET_CLASS_SIGNATURE.matchesExactlyTo(theSignature)) {
            Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.toType(theSignature.getReturnType()), new TypeOfExpression(aProgram, aInstruction.getOpcodeAddress(), aTarget));
            aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
            return true;
        }
        if ("getSuperclass".equals(aMethodName) && BytecodeLinkedClass.GET_SUPERCLASS_SIGNATURE.matchesExactlyTo(theSignature)) {
            Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.toType(theSignature.getReturnType()), new SuperTypeOfExpression(aProgram, aInstruction.getOpcodeAddress(), aTarget));
            aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
            return true;
        }
        if (theCalledClass.name().equals(Class.class.getName())) {
            if ("newInstance".equals(aMethodName)) {
                aHelper.push(aInstruction.getOpcodeAddress(), new NewInstanceFromDefaultConstructorExpression(aProgram, aInstruction.getOpcodeAddress(), aTarget));
                return true;
            }
            if ("desiredAssertionStatus".equals(aMethodName) && theSignature.matchesExactlyTo(BytecodeLinkedClass.DESIRED_ASSERTION_STATUS_SIGNATURE)) {
                aHelper.push(aInstruction.getOpcodeAddress(), new IntegerValue(0));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean intrinsify(Program aProgram, BytecodeInstructionINVOKESTATIC aInstruction, String aMethodName, List<Value> aArguments, BytecodeObjectTypeRef aTargetClass, RegionNode aTargetBlock, ParsingHelper aHelper) {
        BytecodeMethodSignature theSignature = aInstruction.getMethodReference().getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature();
        BytecodeObjectTypeRef theCalledClass = BytecodeObjectTypeRef.fromUtf8Constant(aInstruction.getMethodReference().getClassIndex().getClassConstant().getConstant());
        if (theCalledClass.name().equals(Class.class.getName()) && "forName".equals(aMethodName)) {
            block0: for (int i = 0; i < theSignature.getArguments().length; ++i) {
                if (!theSignature.getArguments()[i].equals(BytecodeObjectTypeRef.fromRuntimeClass(String.class))) continue;
                Value theArgumentValue = aArguments.get(i);
                if (theArgumentValue instanceof StringValue) {
                    String theClassName = ((StringValue)theArgumentValue).getStringValue();
                    if (aProgram.getLinkerContext() == null) continue;
                    aProgram.getLinkerContext().getLogger().warn("Class {} is used by reflection!", new Object[]{theClassName});
                    continue;
                }
                List theIncomingFlows = theArgumentValue.incomingDataFlows();
                for (Value theValue : theIncomingFlows) {
                    if (!(theValue instanceof StringValue)) continue;
                    String theClassName = ((StringValue)theValue).getStringValue();
                    if (aProgram.getLinkerContext() == null) continue block0;
                    aProgram.getLinkerContext().getLogger().warn("Class {} is used by reflection!", new Object[]{theClassName});
                    continue block0;
                }
                if (aProgram.getLinkerContext() == null) continue;
                aProgram.getLinkerContext().getLogger().warn("Class.forName usage detected with unknown class name", new Object[0]);
            }
        }
        return super.intrinsify(aProgram, aInstruction, aMethodName, aArguments, aTargetClass, aTargetBlock, aHelper);
    }

    @Override
    public boolean intrinsify(Program aProgram, BytecodeInstructionINVOKEVIRTUAL aInstruction, String aMethodName, List<Value> aArguments, Value aTarget, RegionNode aTargetBlock, ParsingHelper aHelper) {
        BytecodeMethodSignature theSignature = aInstruction.getMethodReference().getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature();
        BytecodeObjectTypeRef theCalledClass = BytecodeObjectTypeRef.fromUtf8Constant(aInstruction.getMethodReference().getClassIndex().getClassConstant().getConstant());
        if ("getClass".equals(aMethodName) && theSignature.matchesExactlyTo(BytecodeLinkedClass.GET_CLASS_SIGNATURE)) {
            TypeOfExpression theValue = new TypeOfExpression(aProgram, aInstruction.getOpcodeAddress(), aTarget);
            Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.toType(theSignature.getReturnType()), theValue);
            aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
            return true;
        }
        if ("getSuperclass".equals(aMethodName) && BytecodeLinkedClass.GET_SUPERCLASS_SIGNATURE.matchesExactlyTo(theSignature)) {
            Variable theNewVariable = aTargetBlock.newVariable(aInstruction.getOpcodeAddress(), TypeRef.toType(theSignature.getReturnType()), new SuperTypeOfExpression(aProgram, aInstruction.getOpcodeAddress(), aTarget));
            aHelper.push(aInstruction.getOpcodeAddress(), theNewVariable);
            return true;
        }
        if (theCalledClass.name().equals(Class.class.getName())) {
            if ("newInstance".equals(aMethodName)) {
                aHelper.push(aInstruction.getOpcodeAddress(), new NewInstanceFromDefaultConstructorExpression(aProgram, aInstruction.getOpcodeAddress(), aTarget));
                return true;
            }
            if ("desiredAssertionStatus".equals(aMethodName) && theSignature.matchesExactlyTo(BytecodeLinkedClass.DESIRED_ASSERTION_STATUS_SIGNATURE)) {
                aHelper.push(aInstruction.getOpcodeAddress(), new IntegerValue(0));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean intrinsify(Program aProgram, BytecodeInstructionGETSTATIC aInstruction, String aFieldName, BytecodeObjectTypeRef aTtargetType, RegionNode aTargetBlock, ParsingHelper aHelper) {
        if ("$assertionsDisabled".equals(aFieldName)) {
            aHelper.push(aInstruction.getOpcodeAddress(), new IntegerValue(1));
            return true;
        }
        return false;
    }

    @Override
    public boolean intrinsify(Program aProgram, BytecodeInstructionPUTSTATIC aInstruction, String aFieldName, BytecodeObjectTypeRef aTtargetType, Value aValue, RegionNode aTargetBlock, ParsingHelper aHelper) {
        return "$assertionsDisabled".equals(aFieldName);
    }
}

