/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.intrinsics;

import de.mirkosertic.bytecoder.core.BytecodeInstructionGETSTATIC;
import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKESPECIAL;
import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKESTATIC;
import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKEVIRTUAL;
import de.mirkosertic.bytecoder.core.BytecodeInstructionPUTSTATIC;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.intrinsics.Intrinsic;
import de.mirkosertic.bytecoder.intrinsics.JavaLangClassIntrinsic;
import de.mirkosertic.bytecoder.intrinsics.JavaLangDoubleIntrinsic;
import de.mirkosertic.bytecoder.intrinsics.JavaLangEnumIntrinsic;
import de.mirkosertic.bytecoder.intrinsics.JavaLangFloatIntrinsic;
import de.mirkosertic.bytecoder.intrinsics.JavaLangMathIntrinsic;
import de.mirkosertic.bytecoder.intrinsics.JavaLangStrictMathIntrinsic;
import de.mirkosertic.bytecoder.intrinsics.JavaUtilArrayIntrinsic;
import de.mirkosertic.bytecoder.intrinsics.MemoryManagerIntrinsic;
import de.mirkosertic.bytecoder.intrinsics.ObjectConstructorCallIntrinsic;
import de.mirkosertic.bytecoder.intrinsics.VMIntrinsic;
import de.mirkosertic.bytecoder.ssa.ParsingHelper;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import java.util.ArrayList;
import java.util.List;

public class Intrinsics {
    private final List<Intrinsic> intrinsics = new ArrayList<Intrinsic>();

    public Intrinsics() {
        this.intrinsics.add(new MemoryManagerIntrinsic());
        this.intrinsics.add(new JavaUtilArrayIntrinsic());
        this.intrinsics.add(new VMIntrinsic());
        this.intrinsics.add(new JavaLangStrictMathIntrinsic());
        this.intrinsics.add(new JavaLangMathIntrinsic());
        this.intrinsics.add(new JavaLangClassIntrinsic());
        this.intrinsics.add(new ObjectConstructorCallIntrinsic());
        this.intrinsics.add(new JavaLangEnumIntrinsic());
        this.intrinsics.add(new JavaLangFloatIntrinsic());
        this.intrinsics.add(new JavaLangDoubleIntrinsic());
    }

    public boolean intrinsify(Program aProgram, BytecodeInstructionINVOKESTATIC aInstruction, List<Value> aArguments, BytecodeObjectTypeRef aObjectType, RegionNode aTargetBlock, ParsingHelper aHelper) {
        String theMethodName = aInstruction.getMethodReference().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue();
        for (Intrinsic intrinsic : this.intrinsics) {
            if (!intrinsic.intrinsify(aProgram, aInstruction, theMethodName, aArguments, aObjectType, aTargetBlock, aHelper)) continue;
            return true;
        }
        return false;
    }

    public boolean intrinsify(Program aProgram, BytecodeInstructionINVOKESPECIAL aInstruction, BytecodeObjectTypeRef aType, List<Value> aArguments, Variable aTarget, RegionNode aTargetBlock, ParsingHelper aHelper) {
        String theMethodName = aInstruction.getMethodReference().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue();
        for (Intrinsic intrinsic : this.intrinsics) {
            if (!intrinsic.intrinsify(aProgram, aInstruction, theMethodName, aType, aArguments, aTarget, aTargetBlock, aHelper)) continue;
            return true;
        }
        return false;
    }

    public boolean intrinsify(Program aProgram, BytecodeInstructionINVOKEVIRTUAL aInstruction, List<Value> aArguments, Value aTarget, RegionNode aTargetBlock, ParsingHelper aHelper) {
        String theMethodName = aInstruction.getMethodReference().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue();
        for (Intrinsic intrinsic : this.intrinsics) {
            if (!intrinsic.intrinsify(aProgram, aInstruction, theMethodName, aArguments, aTarget, aTargetBlock, aHelper)) continue;
            return true;
        }
        return false;
    }

    public boolean intrinsify(Program aProgram, BytecodeInstructionGETSTATIC aInstruction, RegionNode aTargetBlock, ParsingHelper aHelper) {
        String theFieldName = aInstruction.getConstant().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue();
        BytecodeObjectTypeRef theTargetType = BytecodeObjectTypeRef.fromUtf8Constant(aInstruction.getConstant().getClassIndex().getClassConstant().getConstant());
        for (Intrinsic intrinsic : this.intrinsics) {
            if (!intrinsic.intrinsify(aProgram, aInstruction, theFieldName, theTargetType, aTargetBlock, aHelper)) continue;
            return true;
        }
        return false;
    }

    public boolean intrinsify(Program aProgram, BytecodeInstructionPUTSTATIC aInstruction, Value aValue, RegionNode aTargetBlock, ParsingHelper aHelper) {
        String theFieldName = aInstruction.getConstant().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue();
        BytecodeObjectTypeRef theTargetType = BytecodeObjectTypeRef.fromUtf8Constant(aInstruction.getConstant().getClassIndex().getClassConstant().getConstant());
        for (Intrinsic intrinsic : this.intrinsics) {
            if (!intrinsic.intrinsify(aProgram, aInstruction, theFieldName, theTargetType, aValue, aTargetBlock, aHelper)) continue;
            return true;
        }
        return false;
    }
}

