/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.graph;

import de.mirkosertic.bytecoder.graph.Edge;
import de.mirkosertic.bytecoder.graph.EdgeType;
import de.mirkosertic.bytecoder.graph.Node;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Partitioning<T extends Node<T, ? extends EdgeType>> {
    private final List<Set<T>> partitions = new ArrayList<Set<T>>();

    public Partitioning(Set<T> nodes, Predicate<Edge<EdgeType, T>> edgeFilter) {
        HashSet<T> theWorkList = new HashSet<T>(nodes);
        while (!theWorkList.isEmpty()) {
            Node startNode = (Node)theWorkList.iterator().next();
            Stack<Node> currentPath = new Stack<Node>();
            currentPath.add(startNode);
            HashSet<Node> marked = new HashSet<Node>();
            marked.add(startNode);
            while (!currentPath.isEmpty()) {
                Node currentNode = (Node)currentPath.peek();
                Set theOutgoingNodes = currentNode.outgoingEdges().filter(edge -> edgeFilter.test((Edge)edge)).map(t -> t.targetNode()).collect(Collectors.toSet());
                Set theIncomingNodes = currentNode.incomingEdges().filter(edge -> edgeFilter.test((Edge)edge)).map(t -> t.sourceNode()).collect(Collectors.toSet());
                HashSet theConnectedNodes = new HashSet(theOutgoingNodes);
                theConnectedNodes.addAll(theIncomingNodes);
                if (!theConnectedNodes.isEmpty()) {
                    boolean somethingFound = false;
                    for (Node node : theConnectedNodes) {
                        if (!marked.add(node)) continue;
                        currentPath.push(node);
                        somethingFound = true;
                    }
                    if (somethingFound) continue;
                    currentPath.pop();
                    continue;
                }
                currentPath.pop();
            }
            this.partitions.add(marked);
            theWorkList.removeAll(marked);
        }
    }

    public List<Set<T>> partitions() {
        return this.partitions;
    }
}

