/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.graph;

import de.mirkosertic.bytecoder.graph.Edge;
import de.mirkosertic.bytecoder.graph.EdgeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Node<V extends Node, E extends EdgeType> {
    private final List<Edge<E, V>> outgoingEdges = new ArrayList<Edge<E, V>>();
    private final List<Edge<E, V>> incomingEdges = new ArrayList<Edge<E, V>>();

    protected void addIncomingEdge(Edge aEdge) {
        this.incomingEdges.add(aEdge);
    }

    public <T extends Edge<E, V>> Stream<T> outgoingEdges() {
        return this.outgoingEdges.stream();
    }

    public <T extends Edge<E, V>> Stream<T> outgoingEdges(Predicate<E> aPredicate) {
        return this.outgoingEdges.stream().filter(t -> aPredicate.test(t.edgeType()));
    }

    public <T extends Node> T addEdgeTo(E aType, T aTargetNode) {
        Edge<E, T> theNewEdge = new Edge<E, T>(this, aType, aTargetNode);
        this.outgoingEdges.add(theNewEdge);
        aTargetNode.addIncomingEdge(theNewEdge);
        return aTargetNode;
    }

    public <T extends Edge<E, V>> Stream<T> incomingEdges(Predicate<E> aPredicate) {
        return this.incomingEdges.stream().filter(t -> aPredicate.test(t.edgeType()));
    }

    public <T extends Edge<E, V>> Stream<T> incomingEdges() {
        return this.incomingEdges.stream();
    }

    public <T extends Node> Optional<T> singleOutgoingNodeMatching(Predicate<E> aPredicate) {
        List theEdges = this.outgoingEdges(aPredicate).collect(Collectors.toList());
        if (theEdges.isEmpty()) {
            return Optional.empty();
        }
        if (theEdges.size() > 1) {
            throw new IllegalStateException("Too many edges found!");
        }
        return Optional.of(((Edge)theEdges.get(0)).targetNode());
    }
}

