/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.graph;

import de.mirkosertic.bytecoder.graph.Edge;
import de.mirkosertic.bytecoder.graph.EdgeType;
import de.mirkosertic.bytecoder.graph.Node;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class GraphDFSOrder<T extends Node<? extends Node, ? extends EdgeType>> {
    private final List<T> nodesInOrder;

    public GraphDFSOrder(T graphStartNode, Comparator<T> nodeComparator, Predicate<Edge<EdgeType, T>> edgeFilter) {
        ArrayList<Node> lastNodes = new ArrayList<Node>();
        T startNode = graphStartNode;
        Stack<Object> currentPath = new Stack<Object>();
        currentPath.add(startNode);
        HashSet<Object> marked = new HashSet<Object>();
        marked.add(startNode);
        while (!currentPath.isEmpty()) {
            Node currentNode = (Node)currentPath.peek();
            List forwardNodes = currentNode.outgoingEdges().filter(edge -> edgeFilter.test((Edge)edge)).map(t -> t.targetNode()).sorted(nodeComparator).collect(Collectors.toList());
            if (!forwardNodes.isEmpty()) {
                boolean somethingFound = false;
                for (Node node : forwardNodes) {
                    if (!marked.add(node)) continue;
                    currentPath.push(node);
                    somethingFound = true;
                }
                if (somethingFound) continue;
                lastNodes.add(currentNode);
                currentPath.pop();
                continue;
            }
            lastNodes.add(currentNode);
            currentPath.pop();
        }
        this.nodesInOrder = new ArrayList<T>();
        for (int i = lastNodes.size() - 1; i >= 0; --i) {
            this.nodesInOrder.add(lastNodes.get(i));
        }
    }

    public List<T> getNodesInOrder() {
        return this.nodesInOrder;
    }

    public void printDebug(PrintWriter pw) {
        System.out.println("Topologic order:");
        for (Node node : this.nodesInOrder) {
            pw.print("    ");
            pw.print(node);
            pw.print(" SUCC : ");
            for (Edge edge : node.outgoingEdges().collect(Collectors.toList())) {
                pw.print(edge.edgeType());
                pw.print(":");
                pw.print(edge.targetNode());
                pw.print(" ");
            }
            pw.println();
        }
        pw.flush();
    }
}

