/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.graph;

import de.mirkosertic.bytecoder.graph.Edge;
import de.mirkosertic.bytecoder.graph.EdgeType;
import de.mirkosertic.bytecoder.graph.GraphDFSOrder;
import de.mirkosertic.bytecoder.graph.Node;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Dominators<T extends Node<? extends Node, ? extends EdgeType>> {
    private final List<T> preOrder;
    private final Map<T, T> idom;

    public Dominators(T rootNode, Comparator<T> comparator) {
        this(rootNode, comparator, t -> true);
    }

    public Dominators(T rootNode, Comparator<T> comparator, Predicate<Edge<EdgeType, T>> edgeFilter) {
        this.preOrder = new GraphDFSOrder<T>(rootNode, comparator, edgeFilter).getNodesInOrder();
        this.idom = new HashMap<T, T>();
        this.computeDominators();
    }

    public List<T> getPreOrder() {
        return this.preOrder;
    }

    private void computeDominators() {
        boolean changed;
        Node firstElement = (Node)this.preOrder.get(0);
        this.idom.put(firstElement, firstElement);
        do {
            changed = false;
            for (Node v : this.preOrder) {
                if (v.equals(firstElement)) continue;
                Node oldIdom = this.getIDom(v);
                Object newIdom = null;
                List incomingNodes = v.incomingEdges().map(t -> t.sourceNode()).collect(Collectors.toList());
                for (Node pre : incomingNodes) {
                    if (this.getIDom(pre) == null) continue;
                    if (newIdom == null) {
                        newIdom = pre;
                        continue;
                    }
                    newIdom = this.intersectIDoms(pre, newIdom);
                }
                if (newIdom == null) {
                    throw new AssertionError((Object)("newIDom == null !, for " + v));
                }
                if (newIdom.equals(oldIdom)) continue;
                changed = true;
                this.idom.put(v, newIdom);
            }
        } while (changed);
    }

    public T getIDom(T node) {
        return (T)((Node)this.idom.get(node));
    }

    private T intersectIDoms(T v1, T v2) {
        while (v1 != v2) {
            if (this.preOrder.indexOf(v1) < this.preOrder.indexOf(v2)) {
                v2 = this.getIDom(v2);
                continue;
            }
            v1 = this.getIDom(v1);
        }
        return v1;
    }

    public boolean dominates(T dominator, T dominated) {
        if (dominator.equals(dominated)) {
            return true;
        }
        T dom = this.getIDom(dominated);
        while (dom != null && this.preOrder.indexOf(dom) >= this.preOrder.indexOf(dominator) && !dom.equals(dominator)) {
            dom = this.getIDom(dom);
        }
        return dominator.equals(dom);
    }

    public Set<T> getStrictDominators(T n) {
        HashSet<T> strictDoms = new HashSet<T>();
        T dominated = n;
        T iDom = this.getIDom(n);
        while (iDom != dominated) {
            strictDoms.add(iDom);
            dominated = iDom;
            iDom = this.getIDom(dominated);
        }
        return strictDoms;
    }

    public Set<T> domSetOf(T n) {
        HashSet theDomSet = new HashSet();
        this.addToDomSet(n, theDomSet);
        return theDomSet;
    }

    private void addToDomSet(T n, Set<T> domset) {
        domset.add(n);
        for (Map.Entry<T, T> idomEntry : this.idom.entrySet()) {
            if (idomEntry.getValue() != n || this.preOrder.indexOf(idomEntry.getKey()) <= this.preOrder.indexOf(n)) continue;
            this.addToDomSet((Node)idomEntry.getKey(), domset);
        }
    }
}

