/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.api.Logger;
import java.util.HashMap;
import java.util.Map;

public class Statistics {
    private final Map<String, Context> contexts = new HashMap<String, Context>();

    Statistics() {
    }

    public Context context(String name) {
        return this.contexts.computeIfAbsent(name, t -> new Context());
    }

    public void writeTo(Logger logger) {
        for (Map.Entry<String, Context> ctx : this.contexts.entrySet()) {
            for (Map.Entry ctn : ctx.getValue().counter.entrySet()) {
                logger.info("[Statistics] {}::{} = {}", new Object[]{ctx.getKey(), ctn.getKey(), ((Counter)ctn.getValue()).value});
            }
        }
    }

    public static class Context {
        private final Map<String, Counter> counter = new HashMap<String, Counter>();

        Context() {
        }

        public Counter counter(String name) {
            return this.counter.computeIfAbsent(name, t -> new Counter());
        }
    }

    public static class Counter {
        private int value;

        public void increment() {
            ++this.value;
        }
    }
}

