/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.Statistics;
import de.mirkosertic.bytecoder.ssa.ArrayStoreExpression;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import de.mirkosertic.bytecoder.ssa.DirectInvokeMethodExpression;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.ExpressionListContainer;
import de.mirkosertic.bytecoder.ssa.GetFieldExpression;
import de.mirkosertic.bytecoder.ssa.InvocationExpression;
import de.mirkosertic.bytecoder.ssa.InvokeStaticMethodExpression;
import de.mirkosertic.bytecoder.ssa.InvokeVirtualMethodExpression;
import de.mirkosertic.bytecoder.ssa.NewObjectAndConstructExpression;
import de.mirkosertic.bytecoder.ssa.PHIValue;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.PutFieldExpression;
import de.mirkosertic.bytecoder.ssa.PutStaticExpression;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.ReturnValueExpression;
import de.mirkosertic.bytecoder.ssa.SetEnumConstantsExpression;
import de.mirkosertic.bytecoder.ssa.ThrowExpression;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.ValueWithEscapeCheck;
import de.mirkosertic.bytecoder.ssa.Variable;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public class EscapeAnalysis {
    private final Map<BytecodeLinkedClass, Map<BytecodeMethod, AnalysisResult>> analysisResults = new HashMap<BytecodeLinkedClass, Map<BytecodeMethod, AnalysisResult>>();
    private final Stack<AnalysisResult> workingStack = new Stack();
    private final ProgramDescriptorProvider programDescriptorProvider;
    private final Statistics statistics;

    public EscapeAnalysis(ProgramDescriptorProvider aProgramDescriptorProvider, Statistics aStatistics) {
        this.programDescriptorProvider = aProgramDescriptorProvider;
        this.statistics = aStatistics;
    }

    public AnalysisResult analyze(ProgramDescriptor aProgramDescriptor) {
        BytecodeLinkedClass theLinkedClass = aProgramDescriptor.linkedClass;
        BytecodeMethod theMethod = aProgramDescriptor.method;
        Program theProgram = aProgramDescriptor.program;
        for (AnalysisResult theStackEntry : this.workingStack) {
            if (theStackEntry.method != theMethod) continue;
            for (Variable v : theStackEntry.program.getArguments()) {
                theStackEntry.escaping(v);
            }
            return theStackEntry;
        }
        Map theCached = this.analysisResults.computeIfAbsent(theLinkedClass, t -> new HashMap());
        AnalysisResult theResult = (AnalysisResult)theCached.get(theMethod);
        if (theResult == null) {
            theResult = new AnalysisResult(theMethod, theProgram);
            this.workingStack.push(theResult);
            ControlFlowGraph aGraph = theProgram.getControlFlowGraph();
            for (Variable argument : theProgram.getArguments()) {
                TypeRef theType = argument.resolveType();
                if (!theType.isArray() && !theType.isObject()) continue;
                this.performEscapeAnalysisFor(theResult, argument, argument, argument, new HashSet<Value>(), false, new HashSet<Value>());
            }
            for (RegionNode theNode : aGraph.dominators().getPreOrder()) {
                this.analyze(theResult, theNode.getExpressions(), true);
            }
            this.workingStack.pop();
            theCached.put(theMethod, theResult);
        }
        return theResult;
    }

    private void analyze(AnalysisResult aResult, ExpressionList aExpressionList, boolean aIncludeReturn) {
        for (Expression theExpression : aExpressionList.toList()) {
            if (theExpression instanceof ExpressionListContainer) {
                ExpressionListContainer theContainer = (ExpressionListContainer)((Object)theExpression);
                for (ExpressionList theList : theContainer.getExpressionLists()) {
                    this.analyze(aResult, theList, aIncludeReturn);
                }
            }
            this.analyze(aResult, theExpression, aIncludeReturn);
        }
    }

    private void analyze(AnalysisResult aResult, Expression aExpression, boolean aIncludeReturn) {
        VariableAssignmentExpression theAssignment;
        Value theAssignedValue;
        if (aExpression instanceof VariableAssignmentExpression && (theAssignedValue = (Value)(theAssignment = (VariableAssignmentExpression)aExpression).incomingDataFlows().get(0)) instanceof ValueWithEscapeCheck) {
            this.performEscapeAnalysisFor(aResult, theAssignedValue, theAssignment.getVariable(), theAssignment.getVariable(), new HashSet<Value>(), aIncludeReturn, new HashSet<Value>());
        }
    }

    private boolean performEscapeAnalysisFor(AnalysisResult aResult, Value aValueToCheckEscaping, Value aPreviousValue, Value aCurrentValue, Set<Value> aAlreadySeenPHIs, boolean aIncludeReturn, Set<Value> alreadyAnalyzed) {
        GetFieldExpression theGetField;
        TypeRef theType;
        List theValues;
        Value v;
        int i;
        AnalysisResult theResult;
        ProgramDescriptor theDescriptor;
        List theArguments;
        if (aCurrentValue instanceof PHIValue && !aAlreadySeenPHIs.add(aCurrentValue)) {
            return true;
        }
        if (!(aCurrentValue instanceof InvocationExpression)) {
            alreadyAnalyzed.add(aCurrentValue);
        }
        if (aCurrentValue instanceof ReturnValueExpression && aIncludeReturn) {
            aResult.escaping(aValueToCheckEscaping);
            this.statistics.context("EscapeAnalysis").counter("EscapeByReturn").increment();
            return true;
        }
        if (aCurrentValue instanceof SetEnumConstantsExpression) {
            aResult.escaping(aValueToCheckEscaping);
            this.statistics.context("EscapeAnalysis").counter("EscapeBySetEnumConstant").increment();
            return true;
        }
        if (aCurrentValue instanceof InvokeStaticMethodExpression) {
            InvokeStaticMethodExpression theExpression = (InvokeStaticMethodExpression)aCurrentValue;
            theArguments = aCurrentValue.incomingDataFlows();
            theDescriptor = this.programDescriptorProvider.resolveStaticInvocation(theExpression.getClassName(), theExpression.getMethodName(), theExpression.getSignature());
            if (theDescriptor != null && !theDescriptor.method.getAccessFlags().isNative()) {
                theResult = this.analyze(theDescriptor);
                for (i = 0; i < theArguments.size(); ++i) {
                    v = (Value)theArguments.get(i);
                    if (v != aPreviousValue || !theResult.isMethodArgumentEscaping(i)) continue;
                    aResult.escaping(aValueToCheckEscaping);
                    this.statistics.context("EscapeAnalysis").counter("EscapeByStaticInvocation").increment();
                    return true;
                }
            } else {
                aResult.escaping(aValueToCheckEscaping);
                this.statistics.context("EscapeAnalysis").counter("EscapeByStaticNativeInvocation").increment();
                return true;
            }
        }
        if (aCurrentValue instanceof PutFieldExpression && (theValues = aCurrentValue.incomingDataFlows()).indexOf(aPreviousValue) > 0) {
            aResult.escaping(aValueToCheckEscaping);
            this.statistics.context("EscapeAnalysis").counter("EscapeByPutField").increment();
            return true;
        }
        if (aCurrentValue instanceof PutStaticExpression && (theValues = aCurrentValue.incomingDataFlows()).contains(aPreviousValue)) {
            aResult.escaping(aValueToCheckEscaping);
            this.statistics.context("EscapeAnalysis").counter("EscapeByPutStatic").increment();
            return true;
        }
        if (aCurrentValue instanceof ArrayStoreExpression && (theValues = aCurrentValue.incomingDataFlows()).indexOf(aPreviousValue) == 2) {
            aResult.escaping(aValueToCheckEscaping);
            this.statistics.context("EscapeAnalysis").counter("EscapeByArrayStore").increment();
            return true;
        }
        if (aCurrentValue instanceof NewObjectAndConstructExpression) {
            NewObjectAndConstructExpression newObjectAndConstructExpression = (NewObjectAndConstructExpression)aCurrentValue;
            theArguments = newObjectAndConstructExpression.incomingDataFlows();
            theDescriptor = this.programDescriptorProvider.resolveConstructorInvocation(newObjectAndConstructExpression.getClazz(), newObjectAndConstructExpression.getSignature());
            theResult = this.analyze(theDescriptor);
            for (i = 0; i < theArguments.size(); ++i) {
                v = (Value)theArguments.get(i);
                if (v != aPreviousValue || !theResult.isMethodArgumentEscaping(i)) continue;
                aResult.escaping(aValueToCheckEscaping);
                this.statistics.context("EscapeAnalysis").counter("EscapeByConstructorArgument").increment();
                return true;
            }
        }
        if (aCurrentValue instanceof DirectInvokeMethodExpression) {
            DirectInvokeMethodExpression directInvokeMethodExpression = (DirectInvokeMethodExpression)aCurrentValue;
            theArguments = directInvokeMethodExpression.incomingDataFlows();
            theDescriptor = this.programDescriptorProvider.resolveDirectInvocation(directInvokeMethodExpression.getClazz(), directInvokeMethodExpression.getMethodName(), directInvokeMethodExpression.getSignature());
            if (theDescriptor != null && !theDescriptor.method.getAccessFlags().isNative()) {
                theResult = this.analyze(theDescriptor);
                for (i = 1; i < theArguments.size(); ++i) {
                    v = (Value)theArguments.get(i);
                    if (v != aPreviousValue || !theResult.isMethodArgumentEscaping(i)) continue;
                    aResult.escaping(aValueToCheckEscaping);
                    this.statistics.context("EscapeAnalysis").counter("EscapeByDirectInvocation").increment();
                    return true;
                }
            } else {
                aResult.escaping(aValueToCheckEscaping);
                this.statistics.context("EscapeAnalysis").counter("EscapeByDirectNative").increment();
                return true;
            }
        }
        if (aCurrentValue instanceof InvokeVirtualMethodExpression) {
            aResult.escaping(aValueToCheckEscaping);
            this.statistics.context("EscapeAnalysis").counter("EscapeByVirtual").increment();
            return true;
        }
        if (aCurrentValue instanceof GetFieldExpression && ((theType = (theGetField = (GetFieldExpression)aCurrentValue).resolveType()).isArray() || theType.isObject())) {
            this.statistics.context("EscapeAnalysis").counter("EscapeByGetField").increment();
            aResult.escaping(aValueToCheckEscaping);
            return true;
        }
        if (aCurrentValue instanceof ThrowExpression) {
            aResult.escaping(aValueToCheckEscaping);
            this.statistics.context("EscapeAnalysis").counter("EscapeByThrow").increment();
            return true;
        }
        if (aCurrentValue instanceof VariableAssignmentExpression) {
            VariableAssignmentExpression theAssignment = (VariableAssignmentExpression)aCurrentValue;
            Variable theVariable = theAssignment.getVariable();
            List theOutgoingValues = theVariable.outgoingEdges().map(t -> (Value)t.targetNode()).collect(Collectors.toList());
            boolean theResult2 = false;
            for (Value node : theOutgoingValues) {
                if (alreadyAnalyzed.contains(node)) continue;
                theResult2 |= this.performEscapeAnalysisFor(aResult, aValueToCheckEscaping, theVariable, node, aAlreadySeenPHIs, aIncludeReturn, alreadyAnalyzed);
            }
            if (theResult2) {
                return true;
            }
        }
        boolean result = false;
        List theOutgoingValues = aCurrentValue.outgoingEdges().map(t -> (Value)t.targetNode()).collect(Collectors.toList());
        for (Value node : theOutgoingValues) {
            if (alreadyAnalyzed.contains(node)) continue;
            result |= this.performEscapeAnalysisFor(aResult, aValueToCheckEscaping, aCurrentValue, node, aAlreadySeenPHIs, aIncludeReturn, alreadyAnalyzed);
        }
        return result;
    }

    public static interface ProgramDescriptorProvider {
        public ProgramDescriptor resolveStaticInvocation(BytecodeObjectTypeRef var1, String var2, BytecodeMethodSignature var3);

        public ProgramDescriptor resolveConstructorInvocation(BytecodeObjectTypeRef var1, BytecodeMethodSignature var2);

        public ProgramDescriptor resolveDirectInvocation(BytecodeObjectTypeRef var1, String var2, BytecodeMethodSignature var3);
    }

    public static class ProgramDescriptor {
        private final BytecodeLinkedClass linkedClass;
        private final BytecodeMethod method;
        private final Program program;

        public ProgramDescriptor(BytecodeLinkedClass linkedClass, BytecodeMethod method, Program program) {
            this.linkedClass = linkedClass;
            this.method = method;
            this.program = program;
        }
    }

    public static class AnalysisResult {
        private final BytecodeMethod method;
        private final Program program;
        private final Set<Value> escapingValues;

        public AnalysisResult(BytecodeMethod method, Program program) {
            this.method = method;
            this.program = program;
            this.escapingValues = new HashSet<Value>();
        }

        void escaping(Value value) {
            this.escapingValues.add(value);
            if (value instanceof ValueWithEscapeCheck) {
                ((ValueWithEscapeCheck)((Object)value)).markAsEscaped();
            }
        }

        Set<Value> getEscapingValues() {
            return this.escapingValues;
        }

        public boolean isMethodArgumentEscaping(int aIndex) {
            return this.escapingValues.contains(this.program.getArguments().get(aIndex));
        }
    }
}

