/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class BytecodeVTable {
    private final Map<Slot, VPtr> slots = new HashMap<Slot, VPtr>();

    public void register(BytecodeMethod aMethod, BytecodeLinkedClass aClass) {
        for (Map.Entry<Slot, VPtr> theEntry : this.slots.entrySet()) {
            Slot slot = theEntry.getKey();
            VPtr vPtr = theEntry.getValue();
            if (!aMethod.getName().stringValue().equals(vPtr.methodName) || !aMethod.getSignature().matchesExactlyTo(vPtr.signature)) continue;
            if (!aMethod.getAccessFlags().isAbstract()) {
                this.slots.put(slot, new VPtr(aMethod.getName().stringValue(), aMethod.getSignature(), aClass.getClassName()));
            }
            return;
        }
        Slot newSlot = new Slot(this.slots.size());
        this.slots.put(newSlot, new VPtr(aMethod.getName().stringValue(), aMethod.getSignature(), aClass.getClassName()));
    }

    public List<Slot> sortedSlots() {
        return this.slots.keySet().stream().sorted(Comparator.comparingInt(o -> ((Slot)o).pos)).collect(Collectors.toList());
    }

    public int numberOfSlots() {
        int max = -1;
        for (Slot s : this.slots.keySet()) {
            max = Math.max(max, s.pos);
        }
        return max + 1;
    }

    public VPtr slot(Slot slot) {
        return this.slots.get(slot);
    }

    public Slot slotOf(String methodName, BytecodeMethodSignature signature) {
        for (Map.Entry<Slot, VPtr> theEntry : this.slots.entrySet()) {
            Slot slot = theEntry.getKey();
            VPtr vPtr = theEntry.getValue();
            if (!methodName.equals(vPtr.methodName) || !signature.matchesExactlyTo(vPtr.signature)) continue;
            return slot;
        }
        throw new IllegalArgumentException("No slot for " + methodName + " and signature " + signature);
    }

    public static class VPtr {
        private final String methodName;
        private final BytecodeMethodSignature signature;
        private final BytecodeObjectTypeRef implementingClass;

        VPtr(String methodName, BytecodeMethodSignature signature, BytecodeObjectTypeRef implementingClass) {
            this.methodName = methodName;
            this.signature = signature;
            this.implementingClass = implementingClass;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public BytecodeMethodSignature getSignature() {
            return this.signature;
        }

        public BytecodeObjectTypeRef getImplementingClass() {
            return this.implementingClass;
        }
    }

    public static class Slot {
        private final int pos;

        Slot(int pos) {
            this.pos = pos;
        }

        public int getPos() {
            return this.pos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Slot slot = (Slot)o;
            return this.pos == slot.pos;
        }

        public int hashCode() {
            return Objects.hash(this.pos);
        }
    }
}

