/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeArrayTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeReplacer;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class BytecodeSignatureParser {
    private final BytecodeReplacer replacer;

    public BytecodeSignatureParser(BytecodeReplacer aReplacer) {
        this.replacer = aReplacer;
    }

    private void add(List<BytecodeTypeRef> aTypes, BytecodeTypeRef aType, boolean isArray, int arrayDepth) {
        if (isArray) {
            aTypes.add(new BytecodeArrayTypeRef(aType, arrayDepth));
        } else {
            aTypes.add(aType);
        }
    }

    public BytecodeTypeRef toFieldType(BytecodeUtf8Constant aConstant) {
        BytecodeTypeRef[] theTypes = this.toTypes(aConstant.stringValue());
        return theTypes[0];
    }

    public BytecodeTypeRef[] toTypes(String aTypeList) {
        ArrayList<BytecodeTypeRef> theResult = new ArrayList<BytecodeTypeRef>();
        int p = 0;
        int arrayDepth = 0;
        boolean isArray = false;
        boolean isObject = false;
        StringBuilder objectName = null;
        block17: while (p < aTypeList.length()) {
            char theChar = aTypeList.charAt(p++);
            if (isObject) {
                switch (theChar) {
                    case '[': {
                        if (!isArray) {
                            isArray = true;
                            arrayDepth = 1;
                            continue block17;
                        }
                        ++arrayDepth;
                        continue block17;
                    }
                    case ';': {
                        this.add(theResult, this.replacer.replaceTypeIn(new BytecodeObjectTypeRef(objectName.toString().replace("/", "."))), isArray, arrayDepth);
                        isObject = false;
                        isArray = false;
                        objectName = null;
                        continue block17;
                    }
                }
                objectName.append(theChar);
                continue;
            }
            switch (theChar) {
                case 'Z': {
                    this.add(theResult, BytecodePrimitiveTypeRef.BOOLEAN, isArray, arrayDepth);
                    isArray = false;
                    continue block17;
                }
                case 'B': {
                    this.add(theResult, BytecodePrimitiveTypeRef.BYTE, isArray, arrayDepth);
                    isArray = false;
                    continue block17;
                }
                case 'C': {
                    this.add(theResult, BytecodePrimitiveTypeRef.CHAR, isArray, arrayDepth);
                    isArray = false;
                    continue block17;
                }
                case 'D': {
                    this.add(theResult, BytecodePrimitiveTypeRef.DOUBLE, isArray, arrayDepth);
                    isArray = false;
                    continue block17;
                }
                case 'F': {
                    this.add(theResult, BytecodePrimitiveTypeRef.FLOAT, isArray, arrayDepth);
                    isArray = false;
                    continue block17;
                }
                case 'I': {
                    this.add(theResult, BytecodePrimitiveTypeRef.INT, isArray, arrayDepth);
                    isArray = false;
                    continue block17;
                }
                case 'J': {
                    this.add(theResult, BytecodePrimitiveTypeRef.LONG, isArray, arrayDepth);
                    isArray = false;
                    continue block17;
                }
                case 'S': {
                    this.add(theResult, BytecodePrimitiveTypeRef.SHORT, isArray, arrayDepth);
                    isArray = false;
                    continue block17;
                }
                case 'V': {
                    this.add(theResult, BytecodePrimitiveTypeRef.VOID, isArray, arrayDepth);
                    isArray = false;
                    continue block17;
                }
                case 'L': {
                    isObject = true;
                    objectName = new StringBuilder();
                    continue block17;
                }
                case '[': {
                    if (!isArray) {
                        arrayDepth = 1;
                        isArray = true;
                        continue block17;
                    }
                    ++arrayDepth;
                    continue block17;
                }
            }
            throw new IllegalStateException("Unexpected character " + theChar + " in typelist " + aTypeList);
        }
        return theResult.toArray(new BytecodeTypeRef[theResult.size()]);
    }

    private BytecodeTypeRef toTypeRef(Class aClass) {
        if (aClass == Void.class) {
            return BytecodePrimitiveTypeRef.VOID;
        }
        if (aClass.isPrimitive()) {
            switch (aClass.getSimpleName()) {
                case "void": {
                    return BytecodePrimitiveTypeRef.VOID;
                }
            }
            throw new IllegalArgumentException("Unknown primitive : " + aClass.getSimpleName());
        }
        if (aClass.isArray()) {
            throw new IllegalArgumentException("Unknown array type : " + aClass);
        }
        return BytecodeObjectTypeRef.fromRuntimeClass(aClass);
    }

    public BytecodeMethodSignature toMethodSignature(Method aMethod) {
        BytecodeTypeRef theReturnType = this.toTypeRef(aMethod.getReturnType());
        Class<?>[] theParameter = aMethod.getParameterTypes();
        BytecodeTypeRef[] theReturnValues = new BytecodeTypeRef[theParameter.length];
        for (int i = 0; i < theParameter.length; ++i) {
            theReturnValues[i] = this.toTypeRef(theParameter[i]);
        }
        return new BytecodeMethodSignature(theReturnType, theReturnValues);
    }

    public BytecodeMethodSignature toMethodSignature(BytecodeUtf8Constant aConstant) {
        StringBuilder theBuilder = new StringBuilder(aConstant.stringValue());
        int p = theBuilder.indexOf("(");
        int p2 = theBuilder.lastIndexOf(")");
        String theArguments = theBuilder.substring(p + 1, p2);
        BytecodeTypeRef[] theReturnValue = this.toTypes(theBuilder.substring(p2 + 1));
        if (theReturnValue.length != 1) {
            throw new IllegalArgumentException("Invalid name signature: missing return type : " + theBuilder);
        }
        return new BytecodeMethodSignature(theReturnValue[0], this.toTypes(theArguments));
    }
}

