/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.api.IsObject;
import de.mirkosertic.bytecoder.api.Substitutes;
import de.mirkosertic.bytecoder.api.SubstitutesInClass;
import de.mirkosertic.bytecoder.core.BytecodeAnnotation;
import de.mirkosertic.bytecoder.core.BytecodeAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeClassinfoConstant;
import de.mirkosertic.bytecoder.core.BytecodeField;
import de.mirkosertic.bytecoder.core.BytecodeInterface;
import de.mirkosertic.bytecoder.core.BytecodeLoader;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeReplacer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class BytecodeShadowReplacer
extends BytecodeReplacer {
    private final BytecodeReplacer defaultReplacer;

    public BytecodeShadowReplacer(BytecodeLoader aLoader, BytecodeReplacer aDefaultReplacer) {
        super(aLoader);
        this.defaultReplacer = aDefaultReplacer;
    }

    private BytecodeMethod replaceMethodFrom(BytecodeMethod aMethod, BytecodeClass aShadowType) {
        for (BytecodeMethod theShadowMethod : aShadowType.getMethods()) {
            String theMethodName;
            BytecodeAnnotation theAnnotation = theShadowMethod.getAttributes().getAnnotationByType(Substitutes.class.getName());
            if (!(theAnnotation != null ? Objects.equals(theMethodName = theAnnotation.getElementValueByName("value").stringValue(), aMethod.getName().stringValue()) && theShadowMethod.getSignature().matchesExactlyTo(aMethod.getSignature()) : !"<clinit>".equals(theShadowMethod.getName().stringValue()) && !"<init>".equals(theShadowMethod.getName().stringValue()) && Objects.equals(theShadowMethod.getName().stringValue(), aMethod.getName().stringValue()) && theShadowMethod.getSignature().matchesExactlyTo(aMethod.getSignature()))) continue;
            return aMethod.replaceAndFlagsFrom(theShadowMethod);
        }
        return aMethod;
    }

    @Override
    public BytecodeReplacer.MergeResult replace(BytecodeClassinfoConstant aClass, BytecodeMethod[] aMethods, BytecodeField[] aFields, BytecodeClassinfoConstant aSuperClass, BytecodeInterface[] aInterfaces, BytecodeAttributeInfo[] aClassAttributes) {
        BytecodeObjectTypeRef theObjectType = BytecodeObjectTypeRef.fromUtf8Constant(aClass.getConstant());
        StringBuilder theShadowName = new StringBuilder("de.mirkosertic.bytecoder.classlib.").append(theObjectType.name());
        int p = theShadowName.lastIndexOf(".");
        if (p > 0) {
            theShadowName.insert(p + 1, "T");
        }
        try {
            BytecodeAnnotation theClassAnnotation;
            String theShadowNameStr = theShadowName.toString();
            this.defaultReplacer.addTypeMap(theShadowNameStr, theObjectType.name());
            BytecodeClass theShadowType = this.loader.loadByteCode(new BytecodeObjectTypeRef(theShadowNameStr), this.defaultReplacer);
            BytecodeClassinfoConstant theSuperClass = theShadowType.getSuperClass();
            if (theShadowType.getAttributes().getAnnotationByType(IsObject.class.getName()) != null) {
                theSuperClass = BytecodeClassinfoConstant.OBJECT_CLASS;
            }
            if ((theClassAnnotation = theShadowType.getAttributes().getAnnotationByType(SubstitutesInClass.class.getName())) == null) {
                return new BytecodeReplacer.MergeResult(aMethods, aFields, aSuperClass, aInterfaces, aClassAttributes);
            }
            if (Objects.equals(theClassAnnotation.getElementValueByName("completeReplace").stringValue(), "true")) {
                ArrayList<BytecodeMethod> theMethods = new ArrayList<BytecodeMethod>();
                for (BytecodeMethod aMethod : theShadowType.getMethods()) {
                    BytecodeMethod theReplacement = this.replaceMethodFrom(aMethod, theShadowType);
                    if (theReplacement.getSignature().containsAnyMatches()) {
                        for (BytecodeMethod theOriginal : aMethods) {
                            if (!theOriginal.getName().stringValue().equals(aMethod.getName().stringValue()) || !theReplacement.getSignature().matchesExactlyTo(theOriginal.getSignature())) continue;
                            theMethods.add(theReplacement.replaceSignature(theOriginal));
                        }
                        continue;
                    }
                    theMethods.add(theReplacement);
                }
                return new BytecodeReplacer.MergeResult(theMethods.toArray(new BytecodeMethod[0]), theShadowType.fields(), theSuperClass, theShadowType.getInterfaces(), theShadowType.getAttributesRaw());
            }
            ArrayList<BytecodeField> theFields = new ArrayList<BytecodeField>();
            theFields.addAll(Arrays.asList(theShadowType.fields()));
            theFields.addAll(Arrays.asList(aFields));
            ArrayList<BytecodeMethod> theMethods = new ArrayList<BytecodeMethod>();
            for (BytecodeMethod aMethod : aMethods) {
                theMethods.add(this.replaceMethodFrom(aMethod, theShadowType));
            }
            return new BytecodeReplacer.MergeResult(theMethods.toArray(new BytecodeMethod[0]), theFields.toArray(new BytecodeField[0]), theSuperClass, aInterfaces, aClassAttributes);
        }
        catch (Exception e) {
            return new BytecodeReplacer.MergeResult(aMethods, aFields, aSuperClass, aInterfaces, aClassAttributes);
        }
    }
}

