/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class BytecodeResolvedMethods {
    protected final List<MethodEntry> entries = new ArrayList<MethodEntry>();

    public void merge(BytecodeResolvedMethods aOtherMethods) {
        for (MethodEntry theOtherEntry : aOtherMethods.entries) {
            if (this.entries.contains(theOtherEntry)) continue;
            this.entries.add(theOtherEntry);
        }
    }

    public void register(BytecodeLinkedClass aProvidingClass, BytecodeMethod aMethod) {
        MethodEntry theNewEntry = new MethodEntry(aProvidingClass, aMethod);
        if (!this.entries.contains(theNewEntry)) {
            this.entries.add(theNewEntry);
        }
    }

    public Stream<MethodEntry> stream() {
        return this.entries.stream();
    }

    public boolean isImplementedBy(BytecodeMethod aMethod, BytecodeLinkedClass aClass) {
        for (MethodEntry theEntry : this.entries) {
            BytecodeMethod theSourceMethod;
            if (theEntry.getProvidingClass() != aClass || !(theSourceMethod = theEntry.getValue()).getName().stringValue().equals(aMethod.getName().stringValue()) || !aMethod.getSignature().matchesExactlyTo(theSourceMethod.getSignature())) continue;
            return true;
        }
        return false;
    }

    public MethodEntry implementingClassOf(String aMethodName, BytecodeMethodSignature aSignature) {
        for (int i = this.entries.size() - 1; i >= 0; --i) {
            MethodEntry theEntry = this.entries.get(i);
            BytecodeMethod theMethod = theEntry.getValue();
            if (!theMethod.getName().stringValue().equals(aMethodName) || theMethod.getAccessFlags().isAbstract() || !theMethod.getSignature().matchesExactlyTo(aSignature)) continue;
            return theEntry;
        }
        throw new IllegalArgumentException("Cannot find method " + aMethodName);
    }

    public static class MethodEntry {
        private final BytecodeLinkedClass providingClass;
        private final BytecodeMethod value;

        public MethodEntry(BytecodeLinkedClass aProvidingClass, BytecodeMethod aField) {
            this.providingClass = aProvidingClass;
            this.value = aField;
        }

        public BytecodeLinkedClass getProvidingClass() {
            return this.providingClass;
        }

        public BytecodeMethod getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodEntry that = (MethodEntry)o;
            return Objects.equals(this.providingClass, that.providingClass) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.providingClass, this.value);
        }
    }
}

