/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeField;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class BytecodeResolvedFields {
    protected final List<FieldEntry> entries = new ArrayList<FieldEntry>();

    public void register(BytecodeLinkedClass aProvidingClass, BytecodeField aValue) {
        this.entries.add(new FieldEntry(aProvidingClass, aValue));
    }

    public void merge(BytecodeResolvedFields aOtherFields) {
        this.entries.addAll(aOtherFields.entries);
    }

    public Stream<FieldEntry> stream() {
        return this.entries.stream();
    }

    public Stream<FieldEntry> streamForStaticFields() {
        return this.stream().filter(t -> ((FieldEntry)t).value.getAccessFlags().isStatic());
    }

    public Stream<FieldEntry> streamForInstanceFields() {
        return this.stream().filter(t -> !((FieldEntry)t).value.getAccessFlags().isStatic());
    }

    public FieldEntry fieldByName(String aFieldName) {
        for (int i = this.entries.size() - 1; i >= 0; --i) {
            FieldEntry theEntry = this.entries.get(i);
            if (!Objects.equals(theEntry.getValue().getName().stringValue(), aFieldName)) continue;
            return theEntry;
        }
        return null;
    }

    public static class FieldEntry {
        private final BytecodeLinkedClass providingClass;
        private final BytecodeField value;

        public FieldEntry(BytecodeLinkedClass aProvidingClass, BytecodeField aField) {
            this.providingClass = aProvidingClass;
            this.value = aField;
        }

        public BytecodeLinkedClass getProvidingClass() {
            return this.providingClass;
        }

        public BytecodeField getValue() {
            return this.value;
        }
    }
}

