/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeClassinfoConstant;
import de.mirkosertic.bytecoder.core.BytecodeField;
import de.mirkosertic.bytecoder.core.BytecodeInterface;
import de.mirkosertic.bytecoder.core.BytecodeLoader;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;
import java.util.HashMap;
import java.util.Map;

public class BytecodeReplacer {
    protected final BytecodeLoader loader;
    private final Map<String, String> typeMap;

    public BytecodeReplacer(BytecodeLoader aLoader) {
        this.loader = aLoader;
        this.typeMap = new HashMap<String, String>();
    }

    public void addTypeMap(String aOld, String aNew) {
        this.typeMap.put(aOld, aNew);
    }

    public MergeResult replace(BytecodeClassinfoConstant aClass, BytecodeMethod[] aMethods, BytecodeField[] aFields, BytecodeClassinfoConstant aSuperClass, BytecodeInterface[] aInterfaces, BytecodeAttributeInfo[] aClassAttributes) {
        return new MergeResult(aMethods, aFields, aSuperClass, aInterfaces, aClassAttributes);
    }

    public BytecodeTypeRef replaceTypeIn(BytecodeObjectTypeRef aType) {
        String theNew = this.typeMap.get(aType.name());
        if (theNew != null) {
            return new BytecodeObjectTypeRef(theNew);
        }
        return aType;
    }

    public BytecodeUtf8Constant replaceTypeIn(BytecodeUtf8Constant aType) {
        String theTypeName = aType.stringValue().replace("/", ".");
        String theNew = this.typeMap.get(theTypeName);
        if (theNew != null) {
            return new BytecodeUtf8Constant(theNew.replace(".", "/"));
        }
        return aType;
    }

    public static class MergeResult {
        private final BytecodeMethod[] methods;
        private final BytecodeField[] fields;
        private final BytecodeClassinfoConstant superClass;
        private final BytecodeInterface[] interfaces;
        private final BytecodeAttributeInfo[] classAttributes;

        public MergeResult(BytecodeMethod[] aMethods, BytecodeField[] aFields, BytecodeClassinfoConstant aSuperClass, BytecodeInterface[] aInterfaces, BytecodeAttributeInfo[] aClassAttributes) {
            this.methods = aMethods;
            this.fields = aFields;
            this.superClass = aSuperClass;
            this.interfaces = aInterfaces;
            this.classAttributes = aClassAttributes;
        }

        public BytecodeAttributeInfo[] getClassAttributes() {
            return this.classAttributes;
        }

        public BytecodeMethod[] getMethods() {
            return this.methods;
        }

        public BytecodeField[] getFields() {
            return this.fields;
        }

        public BytecodeClassinfoConstant getSuperClass() {
            return this.superClass;
        }

        public BytecodeInterface[] getInterfaces() {
            return this.interfaces;
        }
    }
}

