/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeBasicBlock;
import de.mirkosertic.bytecoder.core.BytecodeExceptionTableEntry;
import de.mirkosertic.bytecoder.core.BytecodeInstruction;
import de.mirkosertic.bytecoder.core.BytecodeInstructionATHROW;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericRETURN;
import de.mirkosertic.bytecoder.core.BytecodeInstructionInvoke;
import de.mirkosertic.bytecoder.core.BytecodeInstructionObjectRETURN;
import de.mirkosertic.bytecoder.core.BytecodeInstructionRET;
import de.mirkosertic.bytecoder.core.BytecodeInstructionRETURN;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;

public class BytecodeProgram {
    private final List<BytecodeInstruction> instructions = new ArrayList<BytecodeInstruction>();
    private final List<BytecodeExceptionTableEntry> exceptionHandlers = new ArrayList<BytecodeExceptionTableEntry>();

    public void addInstruction(BytecodeInstruction aInstruction) {
        this.instructions.add(aInstruction);
    }

    public void addExceptionHandler(BytecodeExceptionTableEntry aHandler) {
        this.exceptionHandlers.add(aHandler);
    }

    public List<BytecodeInstruction> getInstructions() {
        return this.instructions;
    }

    public boolean isStartOfTryBlock(BytecodeOpcodeAddress aAddress) {
        for (BytecodeExceptionTableEntry aEntry : this.exceptionHandlers) {
            if (!aAddress.equals(aEntry.getStartPC())) continue;
            return true;
        }
        return false;
    }

    public Set<BytecodeOpcodeAddress> getJumpTargets() {
        HashSet<BytecodeOpcodeAddress> theJumpTarget = new HashSet<BytecodeOpcodeAddress>();
        for (BytecodeInstruction theInstruction : this.instructions) {
            if (!theInstruction.isJumpSource()) continue;
            theJumpTarget.addAll(Arrays.asList(theInstruction.getPotentialJumpTargets()));
        }
        for (BytecodeExceptionTableEntry aEntry : this.exceptionHandlers) {
            theJumpTarget.add(aEntry.getHandlerPc());
        }
        return theJumpTarget;
    }

    public List<BytecodeExceptionTableEntry> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public BytecodeInstruction nextInstructionOf(BytecodeInstruction aInstruction) {
        int i = this.instructions.indexOf(aInstruction);
        return this.instructions.get(i + 1);
    }

    public FlowInformation toFlow() {
        HashMap<BytecodeOpcodeAddress, BytecodeBasicBlock> theKnownBlocks = new HashMap<BytecodeOpcodeAddress, BytecodeBasicBlock>();
        Set<BytecodeOpcodeAddress> theJumpTargets = this.getJumpTargets();
        BytecodeBasicBlock theCurrentBlock = null;
        for (BytecodeInstruction theInstruction : this.instructions) {
            if (theJumpTargets.contains(theInstruction.getOpcodeAddress())) {
                theCurrentBlock = null;
            }
            if (this.isStartOfTryBlock(theInstruction.getOpcodeAddress())) {
                theCurrentBlock = null;
            }
            if (theCurrentBlock == null) {
                HashSet<BytecodeUtf8Constant> theCatchType = null;
                BytecodeBasicBlock.Type theType = BytecodeBasicBlock.Type.NORMAL;
                for (BytecodeExceptionTableEntry theHandler : this.getExceptionHandlers()) {
                    if (!Objects.equals(theHandler.getHandlerPc(), theInstruction.getOpcodeAddress())) continue;
                    if (theHandler.isFinally()) {
                        theType = BytecodeBasicBlock.Type.FINALLY;
                        continue;
                    }
                    theType = BytecodeBasicBlock.Type.EXCEPTION_HANDLER;
                    if (theCatchType == null) {
                        theCatchType = new HashSet<BytecodeUtf8Constant>();
                    }
                    theCatchType.add(theHandler.getCatchType().getConstant());
                }
                theCurrentBlock = theCatchType != null ? new BytecodeBasicBlock(theCatchType) : new BytecodeBasicBlock(theType);
                theKnownBlocks.put(theInstruction.getOpcodeAddress(), theCurrentBlock);
            }
            theCurrentBlock.addInstruction(theInstruction);
            if (theInstruction.isJumpSource()) {
                theCurrentBlock = null;
                continue;
            }
            if (theInstruction instanceof BytecodeInstructionRET) {
                theCurrentBlock = null;
                continue;
            }
            if (theInstruction instanceof BytecodeInstructionRETURN) {
                theCurrentBlock = null;
                continue;
            }
            if (theInstruction instanceof BytecodeInstructionObjectRETURN) {
                theCurrentBlock = null;
                continue;
            }
            if (theInstruction instanceof BytecodeInstructionGenericRETURN) {
                theCurrentBlock = null;
                continue;
            }
            if (theInstruction instanceof BytecodeInstructionATHROW) {
                theCurrentBlock = null;
                continue;
            }
            if (!(theInstruction instanceof BytecodeInstructionInvoke)) continue;
            theCurrentBlock = null;
        }
        for (BytecodeExceptionTableEntry theHandler : this.exceptionHandlers) {
            BytecodeBasicBlock theHandlerBlock = (BytecodeBasicBlock)theKnownBlocks.get(theHandler.getHandlerPc());
            if (theHandlerBlock == null) {
                throw new IllegalStateException("No exception handler at " + theHandler.getHandlerPc() + " found !");
            }
            for (Map.Entry theEntry : theKnownBlocks.entrySet()) {
                if (!theHandler.coveres((BytecodeOpcodeAddress)theEntry.getKey())) continue;
                ((BytecodeBasicBlock)theEntry.getValue()).addSuccessor(theHandlerBlock);
            }
        }
        BytecodeOpcodeAddress theRegularStart = new BytecodeOpcodeAddress(0);
        HashMap<BytecodeOpcodeAddress, Set<BytecodeBasicBlock>> theRoots = new HashMap<BytecodeOpcodeAddress, Set<BytecodeBasicBlock>>();
        HashSet<BytecodeBasicBlock> theRegularBlocks = new HashSet<BytecodeBasicBlock>();
        theRoots.put(theRegularStart, this.generateEdges(theRegularBlocks, (BytecodeBasicBlock)theKnownBlocks.get(theRegularStart), new Stack<BytecodeBasicBlock>(), theKnownBlocks));
        for (BytecodeBasicBlock theBlock : theKnownBlocks.values()) {
            if (theBlock.getType() != BytecodeBasicBlock.Type.EXCEPTION_HANDLER) continue;
            HashSet<BytecodeBasicBlock> theAlreadyVisited = new HashSet<BytecodeBasicBlock>(theRegularBlocks);
            this.generateEdges(theAlreadyVisited, theBlock, new Stack<BytecodeBasicBlock>(), theKnownBlocks);
            theAlreadyVisited.removeAll(theRegularBlocks);
            theRoots.put(theBlock.getStartAddress(), theAlreadyVisited);
        }
        return new FlowInformation(theRoots, theKnownBlocks);
    }

    private Set<BytecodeBasicBlock> generateEdges(Set<BytecodeBasicBlock> aVisited, BytecodeBasicBlock aBlock, Stack<BytecodeBasicBlock> aNestingStack, Map<BytecodeOpcodeAddress, BytecodeBasicBlock> aBlocks) {
        aNestingStack.push(aBlock);
        if (aVisited.add(aBlock)) {
            for (BytecodeInstruction theInstruction : aBlock.getInstructions()) {
                if (!theInstruction.isJumpSource()) continue;
                for (BytecodeOpcodeAddress theTarget : theInstruction.getPotentialJumpTargets()) {
                    BytecodeBasicBlock theTargetBlock = aBlocks.get(theTarget);
                    if (!aNestingStack.contains(theTargetBlock)) {
                        aBlock.addSuccessor(theTargetBlock);
                        this.generateEdges(aVisited, theTargetBlock, aNestingStack, aBlocks);
                        continue;
                    }
                    aBlock.addSuccessor(theTargetBlock);
                }
            }
            if (!(aBlock.endsWithReturn() || aBlock.endsWithThrow() || aBlock.endsWithGoto())) {
                BytecodeInstruction theLast = aBlock.lastInstruction();
                BytecodeInstruction theNext = this.nextInstructionOf(theLast);
                BytecodeBasicBlock theNextBlock = aBlocks.get(theNext.getOpcodeAddress());
                aBlock.addSuccessor(theNextBlock);
                this.generateEdges(aVisited, theNextBlock, aNestingStack, aBlocks);
            }
            for (BytecodeBasicBlock theBlock : aBlock.getSuccessors()) {
                if (theBlock.getType() == BytecodeBasicBlock.Type.NORMAL) continue;
                this.generateEdges(aVisited, theBlock, aNestingStack, aBlocks);
            }
        }
        aNestingStack.pop();
        return aVisited;
    }

    public class FlowInformation {
        private final Map<BytecodeOpcodeAddress, Set<BytecodeBasicBlock>> roots;
        private final Map<BytecodeOpcodeAddress, BytecodeBasicBlock> knownBlocks;

        public FlowInformation(Map<BytecodeOpcodeAddress, Set<BytecodeBasicBlock>> roots, Map<BytecodeOpcodeAddress, BytecodeBasicBlock> knownBlocks) {
            this.roots = roots;
            this.knownBlocks = knownBlocks;
        }

        public BytecodeProgram getProgram() {
            return BytecodeProgram.this;
        }

        public BytecodeBasicBlock blockAt(BytecodeOpcodeAddress aBlockAddress) {
            return this.knownBlocks.get(aBlockAddress);
        }

        public Set<BytecodeBasicBlock> knownBlocks() {
            return new HashSet<BytecodeBasicBlock>(this.knownBlocks.values());
        }
    }
}

