/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeTypeRef;

public enum BytecodePrimitiveTypeRef implements BytecodeTypeRef
{
    BOOLEAN{

        @Override
        public Object defaultValue() {
            return false;
        }
    }
    ,
    BYTE{

        @Override
        public Object defaultValue() {
            return (byte)0;
        }
    }
    ,
    CHAR{

        @Override
        public Object defaultValue() {
            return (byte)0;
        }
    }
    ,
    DOUBLE{

        @Override
        public Object defaultValue() {
            return 0.0;
        }
    }
    ,
    FLOAT{

        @Override
        public Object defaultValue() {
            return Float.valueOf(0.0f);
        }
    }
    ,
    LONG{

        @Override
        public Object defaultValue() {
            return 0L;
        }
    }
    ,
    SHORT{

        @Override
        public Object defaultValue() {
            return (short)0;
        }
    }
    ,
    INT{

        @Override
        public Object defaultValue() {
            return 0;
        }
    }
    ,
    VOID{

        @Override
        public Object defaultValue() {
            throw new IllegalStateException("Should never be invoked!");
        }
    };


    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean matchesExactlyTo(BytecodeTypeRef aOtherType) {
        return this.equals(aOtherType);
    }

    @Override
    public boolean isVoid() {
        return this == VOID;
    }
}

