/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.api.AnyTypeMatches;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;

public class BytecodeObjectTypeRef
implements BytecodeTypeRef {
    private final String className;

    public static BytecodeObjectTypeRef fromRuntimeClass(Class aClass) {
        return new BytecodeObjectTypeRef(aClass.getName());
    }

    public static BytecodeObjectTypeRef fromUtf8Constant(BytecodeUtf8Constant aConstant) {
        return new BytecodeObjectTypeRef(aConstant.stringValue().replace("/", "."));
    }

    public BytecodeObjectTypeRef(String aClassName) {
        this.className = aClassName;
    }

    @Override
    public String name() {
        return this.className;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BytecodeObjectTypeRef that = (BytecodeObjectTypeRef)o;
        return this.className.equals(that.className);
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean matchesExactlyTo(BytecodeTypeRef aOtherType) {
        if (!(aOtherType instanceof BytecodeObjectTypeRef)) {
            return false;
        }
        if (AnyTypeMatches.class.getName().equals(this.className)) {
            return true;
        }
        return this.className.equals(((BytecodeObjectTypeRef)aOtherType).className);
    }

    @Override
    public boolean isVoid() {
        return false;
    }

    @Override
    public Object defaultValue() {
        return null;
    }
}

