/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.api.AnyTypeMatches;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;

public class BytecodeMethodSignature {
    private final BytecodeTypeRef returnType;
    private final BytecodeTypeRef[] arguments;

    public BytecodeMethodSignature(BytecodeTypeRef aReturnType, BytecodeTypeRef[] aArguments) {
        this.returnType = aReturnType;
        this.arguments = aArguments;
    }

    public BytecodeTypeRef getReturnType() {
        return this.returnType;
    }

    public BytecodeTypeRef[] getArguments() {
        return this.arguments;
    }

    public boolean matchesExactlyTo(BytecodeMethodSignature aSignature) {
        if (this.arguments.length != aSignature.arguments.length) {
            return false;
        }
        if (!this.returnType.matchesExactlyTo(aSignature.getReturnType())) {
            return false;
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i].matchesExactlyTo(aSignature.arguments[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder theBuilder = new StringBuilder(this.returnType.name());
        theBuilder.append("(");
        for (int i = 0; i < this.arguments.length; ++i) {
            if (i > 0) {
                theBuilder.append(",");
            }
            theBuilder.append(this.arguments[i].name());
        }
        theBuilder.append(")");
        return theBuilder.toString();
    }

    public boolean containsAnyMatches() {
        if (this.isAnyTypeMatchesRef(this.returnType)) {
            return true;
        }
        for (BytecodeTypeRef theType : this.arguments) {
            if (!this.isAnyTypeMatchesRef(theType)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnyTypeMatchesRef(BytecodeTypeRef aType) {
        BytecodeObjectTypeRef theO;
        return aType instanceof BytecodeObjectTypeRef && (theO = (BytecodeObjectTypeRef)aType).name().equals(AnyTypeMatches.class.getName());
    }
}

