/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeArrayTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeVirtualMethodIdentifier;
import java.util.HashMap;
import java.util.Map;

public class BytecodeMethodCollection {
    private final Map<BytecodeMethod, BytecodeVirtualMethodIdentifier> knownIdentifierPerMethod;
    private final Map<String, BytecodeVirtualMethodIdentifier> knownIdentifier = new HashMap<String, BytecodeVirtualMethodIdentifier>();

    public BytecodeMethodCollection() {
        this.knownIdentifierPerMethod = new HashMap<BytecodeMethod, BytecodeVirtualMethodIdentifier>();
    }

    public BytecodeVirtualMethodIdentifier identifierFor(String aMethodName, BytecodeMethodSignature aSignature) {
        String theSignature = this.toSignature(aMethodName, aSignature);
        BytecodeVirtualMethodIdentifier theIdentifier = this.knownIdentifier.get(theSignature);
        if (theIdentifier == null) {
            theIdentifier = new BytecodeVirtualMethodIdentifier(this.knownIdentifier.size());
            this.knownIdentifier.put(theSignature, theIdentifier);
        }
        return theIdentifier;
    }

    public BytecodeVirtualMethodIdentifier identifierFor(BytecodeMethod aMethod) {
        BytecodeVirtualMethodIdentifier theIdentifier = this.knownIdentifierPerMethod.get(aMethod);
        if (theIdentifier == null) {
            theIdentifier = this.identifierFor(aMethod.getName().stringValue(), aMethod.getSignature());
            this.knownIdentifierPerMethod.put(aMethod, theIdentifier);
        }
        return theIdentifier;
    }

    public BytecodeVirtualMethodIdentifier toIdentifier(String aMethodName, BytecodeMethodSignature aSignature) {
        return this.knownIdentifier.get(this.toSignature(aMethodName, aSignature));
    }

    private String toSignature(String aMethodName, BytecodeMethodSignature aSignature) {
        StringBuilder theStringBuilder = new StringBuilder();
        theStringBuilder.append(this.toSignature(aSignature.getReturnType()));
        theStringBuilder.append(aMethodName);
        for (BytecodeTypeRef theRef : aSignature.getArguments()) {
            theStringBuilder.append(this.toSignature(theRef));
        }
        return theStringBuilder.toString();
    }

    private String toSignature(BytecodeTypeRef aTypeRef) {
        if (aTypeRef instanceof BytecodeObjectTypeRef) {
            BytecodeObjectTypeRef theTypeRef = (BytecodeObjectTypeRef)aTypeRef;
            return theTypeRef.name().replace(".", "_");
        }
        if (aTypeRef instanceof BytecodePrimitiveTypeRef) {
            BytecodePrimitiveTypeRef theRef = (BytecodePrimitiveTypeRef)aTypeRef;
            return theRef.name();
        }
        BytecodeArrayTypeRef theArrayRef = (BytecodeArrayTypeRef)aTypeRef;
        return "A" + theArrayRef.getDepth() + this.toSignature(theArrayRef.getType());
    }
}

