/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.api.DelegatesTo;
import de.mirkosertic.bytecoder.api.EmulatedByRuntime;
import de.mirkosertic.bytecoder.core.BytecodeAccessFlags;
import de.mirkosertic.bytecoder.core.BytecodeAnnotation;
import de.mirkosertic.bytecoder.core.BytecodeAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeAttributes;
import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeCodeAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;
import de.mirkosertic.bytecoder.graph.EdgeType;
import de.mirkosertic.bytecoder.graph.Node;
import java.util.Objects;

public class BytecodeMethod
extends Node<Node, EdgeType> {
    private final BytecodeAccessFlags accessFlags;
    private final BytecodeUtf8Constant name;
    private final BytecodeAttributeInfo[] attributes;
    private final BytecodeMethodSignature signature;
    private final BytecodeAttributes mappedAttributes;

    public BytecodeMethod(BytecodeAccessFlags aAccessFlags, BytecodeUtf8Constant aName, BytecodeMethodSignature aSignature, BytecodeAttributeInfo[] aAttributes) {
        this.accessFlags = aAccessFlags;
        this.name = aName;
        this.signature = aSignature;
        this.attributes = aAttributes;
        this.mappedAttributes = new BytecodeAttributes(this.attributes);
    }

    public BytecodeMethod replaceAndFlagsFrom(BytecodeMethod aOtherMethod) {
        return new BytecodeMethod(aOtherMethod.accessFlags, this.name, this.signature, aOtherMethod.attributes);
    }

    public BytecodeMethod replaceSignature(BytecodeMethod aOtherMethod) {
        return new BytecodeMethod(aOtherMethod.accessFlags, this.name, aOtherMethod.getSignature(), this.attributes);
    }

    public BytecodeAttributes getAttributes() {
        return this.mappedAttributes;
    }

    public BytecodeUtf8Constant getName() {
        return this.name;
    }

    public BytecodeAccessFlags getAccessFlags() {
        return this.accessFlags;
    }

    public BytecodeCodeAttributeInfo getCode(BytecodeClass aContextClass) {
        BytecodeAnnotation theDelegatesTo = this.getAttributes().getAnnotationByType(DelegatesTo.class.getName());
        if (theDelegatesTo != null) {
            BytecodeAnnotation.ElementValue theMethodToDelegate = theDelegatesTo.getElementValueByName("methodName");
            String theDelegatingMethod = theMethodToDelegate.stringValue();
            BytecodeMethod theMethod = aContextClass.methodByNameAndSignatureOrNull(theDelegatingMethod, this.getSignature());
            if (theMethod == null) {
                throw new IllegalStateException("Cannot find method " + theDelegatingMethod + " in " + aContextClass.getThisInfo().getConstant().stringValue());
            }
            return theMethod.getCode(aContextClass);
        }
        return this.attributeByType(BytecodeCodeAttributeInfo.class);
    }

    public <T extends BytecodeAttributeInfo> T attributeByType(Class<T> aAttributeClass) {
        for (BytecodeAttributeInfo theInfo : this.attributes) {
            if (!Objects.equals(theInfo.getClass(), aAttributeClass)) continue;
            return (T)theInfo;
        }
        return null;
    }

    public boolean emulatedByRuntime() {
        return this.getAttributes().getAnnotationByType(EmulatedByRuntime.class.getName()) != null;
    }

    public BytecodeMethodSignature getSignature() {
        return this.signature;
    }

    public boolean isConstructor() {
        return Objects.equals(this.name.stringValue(), "<init>");
    }

    public boolean isClassInitializer() {
        return Objects.equals(this.name.stringValue(), "<clinit>");
    }
}

