/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeConstantPool;
import de.mirkosertic.bytecoder.core.BytecodeLocalVariableTableEntry;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;

public class BytecodeLocalVariableTableAttributeInfo
implements BytecodeAttributeInfo {
    private final BytecodeConstantPool constantPool;
    private final BytecodeLocalVariableTableEntry[] entries;

    public BytecodeLocalVariableTableAttributeInfo(BytecodeConstantPool aConstantPool, BytecodeLocalVariableTableEntry[] aEntry) {
        this.entries = aEntry;
        this.constantPool = aConstantPool;
    }

    public BytecodeLocalVariableTableEntry matchingEntryFor(BytecodeOpcodeAddress aAddress, int aIndex) {
        for (BytecodeLocalVariableTableEntry theEntry : this.entries) {
            if (theEntry.getIndex() != aIndex || aAddress.getAddress() < theEntry.getStartPC() || aAddress.getAddress() >= theEntry.getStartPC() + theEntry.getLength()) continue;
            return theEntry;
        }
        return null;
    }

    public String resolveVariableName(BytecodeLocalVariableTableEntry aEntry) {
        if (aEntry.getStartPC() == 0) {
            return ((BytecodeUtf8Constant)this.constantPool.constantByIndex(aEntry.getNameIndex() - 1)).stringValue();
        }
        return ((BytecodeUtf8Constant)this.constantPool.constantByIndex(aEntry.getNameIndex() - 1)).stringValue() + "_" + aEntry.getStartPC();
    }
}

