/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.api.ClassLibProvider;
import de.mirkosertic.bytecoder.core.Bytecode5XProgramParser;
import de.mirkosertic.bytecoder.core.Bytecode5xClassParser;
import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeClassParser;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeReplacer;
import de.mirkosertic.bytecoder.core.BytecodeShadowReplacer;
import de.mirkosertic.bytecoder.core.BytecodeSignatureParser;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BytecodeLoader {
    private final BytecodeSignatureParser signatureParser;
    private final ClassLoader classLoader;
    private final BytecodeReplacer bytecodeReplacer;
    private final BytecodeShadowReplacer shadowReplacer;

    public BytecodeLoader(ClassLoader aClassLoader) {
        this.classLoader = aClassLoader;
        this.bytecodeReplacer = new BytecodeReplacer(this);
        this.shadowReplacer = new BytecodeShadowReplacer(this, this.bytecodeReplacer);
        this.signatureParser = new BytecodeSignatureParser(this.bytecodeReplacer);
    }

    public BytecodeSignatureParser getSignatureParser() {
        return this.signatureParser;
    }

    public BytecodeClass loadByteCode(BytecodeObjectTypeRef aTypeRef) throws IOException, ClassNotFoundException {
        return this.loadByteCode(aTypeRef, this.bytecodeReplacer);
    }

    public BytecodeClass loadByteCode(BytecodeObjectTypeRef aTypeRef, BytecodeReplacer aDefaultReplacer) throws IOException, ClassNotFoundException {
        String theResourceName = aTypeRef.name().replace(".", "/") + ".class";
        for (ClassLibProvider theProvider : ClassLibProvider.availableProviders()) {
            InputStream theStream = this.classLoader.getResourceAsStream(theProvider.getResourceBase() + "/" + theResourceName);
            if (theStream == null) continue;
            try (DataInputStream dis = new DataInputStream(theStream);){
                BytecodeClassParser parser = this.parseHeader(dis, this.shadowReplacer);
                BytecodeClass bytecodeClass = parser.parseBody(dis);
                return bytecodeClass;
            }
        }
        if (aTypeRef.name().startsWith("java.") || aTypeRef.name().startsWith("javax.")) {
            throw new IllegalArgumentException("Not supported Java module for class " + aTypeRef.name());
        }
        InputStream theStream = this.classLoader.getResourceAsStream(theResourceName);
        if (theStream == null) {
            throw new ClassNotFoundException(theResourceName);
        }
        try (DataInputStream dis = new DataInputStream(theStream);){
            BytecodeClassParser parser = this.parseHeader(dis, aDefaultReplacer);
            BytecodeClass bytecodeClass = parser.parseBody(dis);
            return bytecodeClass;
        }
    }

    private BytecodeClassParser parseHeader(DataInput aStream, BytecodeReplacer aReplacer) throws IOException {
        int theMagic = aStream.readInt();
        if (theMagic != -889275714) {
            throw new IllegalArgumentException("Wrong class file format : " + theMagic);
        }
        int theMinorVersion = aStream.readUnsignedShort();
        int theMajorVersion = aStream.readUnsignedShort();
        switch (theMajorVersion) {
            case 47: {
                return new Bytecode5xClassParser(new Bytecode5XProgramParser(), this.signatureParser, aReplacer);
            }
            case 48: {
                return new Bytecode5xClassParser(new Bytecode5XProgramParser(), this.signatureParser, aReplacer);
            }
            case 49: {
                return new Bytecode5xClassParser(new Bytecode5XProgramParser(), this.signatureParser, aReplacer);
            }
            case 50: {
                return new Bytecode5xClassParser(new Bytecode5XProgramParser(), this.signatureParser, aReplacer);
            }
            case 51: {
                return new Bytecode5xClassParser(new Bytecode5XProgramParser(), this.signatureParser, aReplacer);
            }
            case 52: {
                return new Bytecode5xClassParser(new Bytecode5XProgramParser(), this.signatureParser, aReplacer);
            }
            case 53: {
                return new Bytecode5xClassParser(new Bytecode5XProgramParser(), this.signatureParser, aReplacer);
            }
            case 54: {
                return new Bytecode5xClassParser(new Bytecode5XProgramParser(), this.signatureParser, aReplacer);
            }
            case 55: {
                return new Bytecode5xClassParser(new Bytecode5XProgramParser(), this.signatureParser, aReplacer);
            }
            case 56: {
                return new Bytecode5xClassParser(new Bytecode5XProgramParser(), this.signatureParser, aReplacer);
            }
            case 57: {
                return new Bytecode5xClassParser(new Bytecode5XProgramParser(), this.signatureParser, aReplacer);
            }
            case 58: {
                return new Bytecode5xClassParser(new Bytecode5XProgramParser(), this.signatureParser, aReplacer);
            }
        }
        throw new IllegalArgumentException("Not Supported bytecode format : " + theMajorVersion);
    }
}

