/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.api.Export;
import de.mirkosertic.bytecoder.api.Logger;
import de.mirkosertic.bytecoder.core.BytecodeAnnotation;
import de.mirkosertic.bytecoder.core.BytecodeArrayTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeClassinfoConstant;
import de.mirkosertic.bytecoder.core.BytecodeImplementsEdgeType;
import de.mirkosertic.bytecoder.core.BytecodeInterface;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClassEdgeType;
import de.mirkosertic.bytecoder.core.BytecodeLoader;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodCollection;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeSignatureParser;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;
import de.mirkosertic.bytecoder.core.RootNode;
import de.mirkosertic.bytecoder.core.Statistics;
import de.mirkosertic.bytecoder.graph.Edge;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BytecodeLinkerContext {
    private final RootNode rootNode = new RootNode();
    private final BytecodeLoader loader;
    private final BytecodeMethodCollection methodCollection;
    private final Logger logger;
    private int classIdCounter;
    private final Statistics statistics;

    public BytecodeLinkerContext(BytecodeLoader aLoader, Logger aLogger) {
        this.loader = aLoader;
        this.methodCollection = new BytecodeMethodCollection();
        this.logger = aLogger;
        this.classIdCounter = 0;
        this.statistics = new Statistics();
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public BytecodeSignatureParser getSignatureParser() {
        return this.loader.getSignatureParser();
    }

    public BytecodeMethodCollection getMethodCollection() {
        return this.methodCollection;
    }

    public BytecodeLinkedClass isLinkedOrNull(BytecodeUtf8Constant aConstant) {
        BytecodeObjectTypeRef theTypeRef = BytecodeObjectTypeRef.fromUtf8Constant(aConstant);
        List theLinkedClass = this.linkedClasses().filter(t -> ((BytecodeLinkedClass)t.targetNode()).getClassName().equals(theTypeRef)).map(Edge::targetNode).collect(Collectors.toList());
        if (theLinkedClass.size() > 1) {
            throw new IllegalStateException();
        }
        if (theLinkedClass.size() == 1) {
            return (BytecodeLinkedClass)theLinkedClass.get(0);
        }
        return null;
    }

    public BytecodeLinkedClass resolveClass(BytecodeObjectTypeRef aTypeRef) {
        List theFoundLinks = this.linkedClasses().map(Edge::targetNode).filter(t -> t.getClassName().equals(aTypeRef)).collect(Collectors.toList());
        if (!theFoundLinks.isEmpty()) {
            return (BytecodeLinkedClass)theFoundLinks.get(0);
        }
        try {
            BytecodeClass theLoadedClass = this.loader.loadByteCode(aTypeRef);
            BytecodeLinkedClass theParentClass = null;
            BytecodeClassinfoConstant theSuperClass = theLoadedClass.getSuperClass();
            if (theSuperClass != BytecodeClassinfoConstant.OBJECT_CLASS) {
                BytecodeUtf8Constant theSuperClassName = theSuperClass.getConstant();
                theParentClass = this.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(theSuperClassName));
            }
            BytecodeLinkedClass theLinkedClass = new BytecodeLinkedClass(theParentClass, this.classIdCounter++, this, aTypeRef, theLoadedClass);
            this.rootNode.addEdgeTo(BytecodeLinkedClassEdgeType.instance, theLinkedClass);
            for (BytecodeMethod theMethod : theLoadedClass.getMethods()) {
                BytecodeAnnotation theAnnotation = theMethod.getAttributes().getAnnotationByType(Export.class.getName());
                if (theAnnotation == null) continue;
                if (theMethod.getAccessFlags().isStatic()) {
                    theLinkedClass.resolveStaticMethod(theMethod.getName().stringValue(), theMethod.getSignature());
                    continue;
                }
                theLinkedClass.resolveVirtualMethod(theMethod.getName().stringValue(), theMethod.getSignature());
            }
            for (BytecodeInterface theInterface : theLoadedClass.getInterfaces()) {
                BytecodeUtf8Constant theSuperClassName = theInterface.getClassinfoConstant().getConstant();
                BytecodeLinkedClass theImplementedClass = this.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(theSuperClassName));
                theLinkedClass.addEdgeTo(BytecodeImplementsEdgeType.instance, theImplementedClass);
            }
            BytecodeMethod theMethod = theLoadedClass.classInitializerOrNull();
            if (theMethod != null) {
                theLinkedClass.resolveClassInitializer(theMethod);
            }
            this.logger.info("Linked {}", new Object[]{theLinkedClass.getClassName().name()});
            this.statistics.context("Linker context").counter("Loaded classes").increment();
            return theLinkedClass;
        }
        catch (Exception e) {
            throw new RuntimeException("Error linking class " + aTypeRef.name(), e);
        }
    }

    public Stream<Edge<BytecodeLinkedClassEdgeType, BytecodeLinkedClass>> linkedClasses() {
        return this.rootNode.outgoingEdges();
    }

    public void resolveTypeRef(BytecodeTypeRef aTypeRef) {
        if (aTypeRef.isVoid()) {
            return;
        }
        if (aTypeRef.isPrimitive()) {
            return;
        }
        if (aTypeRef.isArray()) {
            BytecodeArrayTypeRef theArray = (BytecodeArrayTypeRef)aTypeRef;
            this.resolveTypeRef(theArray.getType());
            return;
        }
        BytecodeObjectTypeRef theTypeRef = (BytecodeObjectTypeRef)aTypeRef;
        this.resolveClass(theTypeRef);
    }

    public void resolveAbstractMethodsInSubclasses() {
        List theLinkedClasses = this.linkedClasses().map(Edge::targetNode).collect(Collectors.toList());
        for (BytecodeLinkedClass theLinked : theLinkedClasses) {
            theLinked.resolveInheritedOverriddenMethods();
        }
        if (this.linkedClasses().count() != (long)theLinkedClasses.size()) {
            this.resolveAbstractMethodsInSubclasses();
        }
    }
}

