/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.api.Callback;
import de.mirkosertic.bytecoder.api.EmulatedByRuntime;
import de.mirkosertic.bytecoder.api.Import;
import de.mirkosertic.bytecoder.api.OpaqueReferenceType;
import de.mirkosertic.bytecoder.api.web.Event;
import de.mirkosertic.bytecoder.core.BytecodeAnnotation;
import de.mirkosertic.bytecoder.core.BytecodeArrayTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeCodeAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeExceptionTableEntry;
import de.mirkosertic.bytecoder.core.BytecodeField;
import de.mirkosertic.bytecoder.core.BytecodeImplementsEdgeType;
import de.mirkosertic.bytecoder.core.BytecodeImportedLink;
import de.mirkosertic.bytecoder.core.BytecodeInstruction;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeProgram;
import de.mirkosertic.bytecoder.core.BytecodeProvidesFieldEdgeType;
import de.mirkosertic.bytecoder.core.BytecodeProvidesMethodEdgeType;
import de.mirkosertic.bytecoder.core.BytecodeResolvedFields;
import de.mirkosertic.bytecoder.core.BytecodeResolvedMethods;
import de.mirkosertic.bytecoder.core.BytecodeSubclassOfEdgeType;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;
import de.mirkosertic.bytecoder.core.BytecodeVTable;
import de.mirkosertic.bytecoder.graph.EdgeType;
import de.mirkosertic.bytecoder.graph.Node;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class BytecodeLinkedClass
extends Node<Node, EdgeType> {
    public static final BytecodeMethodSignature GET_CLASS_SIGNATURE = new BytecodeMethodSignature(BytecodeObjectTypeRef.fromRuntimeClass(Class.class), new BytecodeTypeRef[0]);
    public static final BytecodeMethodSignature GET_CLASSLOADER_SIGNATURE = new BytecodeMethodSignature(BytecodeObjectTypeRef.fromRuntimeClass(ClassLoader.class), new BytecodeTypeRef[0]);
    public static final BytecodeMethodSignature DESIRED_ASSERTION_STATUS_SIGNATURE = new BytecodeMethodSignature(BytecodePrimitiveTypeRef.BOOLEAN, new BytecodeTypeRef[0]);
    public static final BytecodeMethodSignature GET_ENUM_CONSTANTS_SIGNATURE = new BytecodeMethodSignature(new BytecodeArrayTypeRef(BytecodeObjectTypeRef.fromRuntimeClass(Object.class), 1), new BytecodeTypeRef[0]);
    public static final BytecodeMethodSignature CLASS_FOR_NAME_SIGNATURE = new BytecodeMethodSignature(BytecodeObjectTypeRef.fromRuntimeClass(Class.class), new BytecodeTypeRef[]{BytecodeObjectTypeRef.fromRuntimeClass(String.class), BytecodePrimitiveTypeRef.BOOLEAN, BytecodeObjectTypeRef.fromRuntimeClass(ClassLoader.class)});
    public static final BytecodeMethodSignature GET_SUPERCLASS_SIGNATURE = new BytecodeMethodSignature(BytecodeObjectTypeRef.fromRuntimeClass(Class.class), new BytecodeTypeRef[0]);
    private final int uniqueId;
    private final BytecodeObjectTypeRef className;
    private final BytecodeClass bytecodeClass;
    private final BytecodeLinkerContext linkerContext;
    private BytecodeMethod classInitializer;
    private Boolean opaque;
    private Boolean callback;
    private Boolean event;
    private final BytecodeLinkedClass superClass;
    private final Map<String, Set<BytecodeLinkedClass>> implementingTypesCache = new HashMap<String, Set<BytecodeLinkedClass>>();

    public BytecodeLinkedClass(BytecodeLinkedClass aSuperclass, int aUniqueId, BytecodeLinkerContext aLinkerContext, BytecodeObjectTypeRef aClassName, BytecodeClass aBytecodeClass) {
        this.uniqueId = aUniqueId;
        this.className = aClassName;
        this.bytecodeClass = aBytecodeClass;
        this.linkerContext = aLinkerContext;
        this.superClass = aSuperclass;
        if (this.superClass != null) {
            this.addEdgeTo(BytecodeSubclassOfEdgeType.instance, this.superClass);
        }
    }

    public boolean isOpaqueType() {
        if (this.opaque != null) {
            return this.opaque;
        }
        Set<BytecodeLinkedClass> theImplementingTypes = this.getImplementingTypes();
        for (BytecodeLinkedClass theClass : theImplementingTypes) {
            if (!theClass.getClassName().name().equals(OpaqueReferenceType.class.getName())) continue;
            this.opaque = true;
            return this.opaque;
        }
        this.opaque = false;
        return this.opaque;
    }

    public boolean isCallback() {
        if (this.callback != null) {
            return this.callback;
        }
        Set<BytecodeLinkedClass> theImplementingTypes = this.getImplementingTypes();
        for (BytecodeLinkedClass theClass : theImplementingTypes) {
            if (!theClass.getClassName().name().equals(Callback.class.getName())) continue;
            this.callback = true;
            return this.callback;
        }
        this.callback = false;
        return this.callback;
    }

    public boolean isEvent() {
        if (this.event != null) {
            return this.event;
        }
        Set<BytecodeLinkedClass> theImplementingTypes = this.getImplementingTypes();
        for (BytecodeLinkedClass theClass : theImplementingTypes) {
            if (!theClass.getClassName().name().equals(Event.class.getName())) continue;
            this.event = true;
            return this.event;
        }
        this.event = false;
        return this.event;
    }

    public boolean emulatedByRuntime() {
        return this.bytecodeClass.getAttributes().getAnnotationByType(EmulatedByRuntime.class.getName()) != null;
    }

    public BytecodeObjectTypeRef getClassName() {
        return this.className;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public Set<BytecodeLinkedClass> getImplementingTypes() {
        return this.getImplementingTypes(true, true);
    }

    public Set<BytecodeLinkedClass> getImplementingTypes(boolean aIncludeSuperClass, boolean aIncludeSelf) {
        String key = aIncludeSuperClass + "_" + aIncludeSelf;
        return this.implementingTypesCache.computeIfAbsent(key, aKey -> {
            BytecodeLinkedClass theSuperClass;
            HashSet<BytecodeLinkedClass> theTempResult = new HashSet<BytecodeLinkedClass>();
            if (aIncludeSelf) {
                theTempResult.add(this);
            }
            this.outgoingEdges(BytecodeImplementsEdgeType.filter()).forEach(edge -> {
                BytecodeLinkedClass theLinkedClass = (BytecodeLinkedClass)edge.targetNode();
                theTempResult.addAll(theLinkedClass.getImplementingTypes());
            });
            if (aIncludeSuperClass && (theSuperClass = this.getSuperClass()) != null) {
                theTempResult.addAll(theSuperClass.getImplementingTypes());
            }
            return theTempResult;
        });
    }

    public BytecodeLinkedClass getSuperClass() {
        return this.superClass;
    }

    public void resolveClassInitializer(BytecodeMethod aMethod) {
        this.classInitializer = aMethod;
        this.resolveStaticMethod(aMethod.getName().stringValue(), aMethod.getSignature());
    }

    public boolean resolveStaticField(BytecodeUtf8Constant aName) {
        String theFieldName = aName.stringValue();
        if (this.outgoingEdges(BytecodeProvidesFieldEdgeType.filter()).map(t -> (BytecodeField)t.targetNode()).anyMatch(t -> Objects.equals(t.getName().stringValue(), theFieldName) && t.getAccessFlags().isStatic())) {
            return true;
        }
        BytecodeField theField = this.bytecodeClass.fieldByName(theFieldName);
        if (theField != null) {
            if (!theField.getAccessFlags().isStatic()) {
                throw new IllegalStateException("Field " + theFieldName + " is not static in " + this.className.name());
            }
            this.addEdgeTo(BytecodeProvidesFieldEdgeType.instance, theField);
            this.linkerContext.resolveTypeRef(theField.getTypeRef());
            return true;
        }
        for (BytecodeLinkedClass theImplementedInterface : this.getImplementingTypes(false, false)) {
            if (!theImplementedInterface.resolveStaticField(aName)) continue;
            return true;
        }
        BytecodeLinkedClass theSuperClass = this.getSuperClass();
        if (theSuperClass != null) {
            return theSuperClass.resolveStaticField(aName);
        }
        return false;
    }

    public boolean resolveInstanceField(BytecodeUtf8Constant aName) {
        String theFieldName = aName.stringValue();
        HashMap theFields = new HashMap();
        this.outgoingEdges(BytecodeProvidesFieldEdgeType.filter()).map(t -> (BytecodeField)t.targetNode()).forEach(t -> theFields.put(t.getName().stringValue(), t));
        BytecodeField theField = (BytecodeField)theFields.get(theFieldName);
        if (theField != null) {
            if (theField.getAccessFlags().isStatic()) {
                throw new IllegalStateException("Field " + theFieldName + " is static in " + this.className.name());
            }
            return true;
        }
        theField = this.bytecodeClass.fieldByName(theFieldName);
        if (theField != null) {
            if (theField.getAccessFlags().isStatic()) {
                throw new IllegalStateException("Field " + theFieldName + " is static in " + this.className.name());
            }
            this.addEdgeTo(BytecodeProvidesFieldEdgeType.instance, theField);
            this.linkerContext.resolveTypeRef(theField.getTypeRef());
            return true;
        }
        BytecodeLinkedClass theSuperClass = this.getSuperClass();
        if (theSuperClass != null) {
            return theSuperClass.resolveInstanceField(aName);
        }
        return false;
    }

    public BytecodeResolvedFields resolvedFields() {
        BytecodeLinkedClass theSuperclass = this.getSuperClass();
        BytecodeResolvedFields theMap = theSuperclass != null ? theSuperclass.resolvedFields() : new BytecodeResolvedFields();
        for (BytecodeLinkedClass theImplementedInterface : this.getImplementingTypes(false, false)) {
            BytecodeResolvedFields theInterfaceFields = theImplementedInterface.resolvedFields();
            theMap.merge(theInterfaceFields);
        }
        this.outgoingEdges(BytecodeProvidesFieldEdgeType.filter()).map(t -> (BytecodeField)t.targetNode()).forEach(aField -> theMap.register(this, (BytecodeField)aField));
        return theMap;
    }

    public BytecodeVTable resolveVTable() {
        BytecodeLinkedClass theSuperclass = this.getSuperClass();
        BytecodeVTable theTable = theSuperclass != null ? theSuperclass.resolveVTable() : new BytecodeVTable();
        for (BytecodeLinkedClass theImplementedInterface : this.getImplementingTypes(false, false)) {
            theImplementedInterface.outgoingEdges(BytecodeProvidesMethodEdgeType.filter()).forEach(c -> {
                BytecodeLinkedClass theClass = (BytecodeLinkedClass)c.sourceNode();
                BytecodeMethod theMethod = (BytecodeMethod)c.targetNode();
                if (!(theMethod.isClassInitializer() || theMethod.isConstructor() || theMethod.getAccessFlags().isStatic())) {
                    theTable.register(theMethod, theClass);
                }
            });
        }
        this.outgoingEdges(BytecodeProvidesMethodEdgeType.filter()).forEach(c -> {
            BytecodeLinkedClass theClass = (BytecodeLinkedClass)c.sourceNode();
            BytecodeMethod theMethod = (BytecodeMethod)c.targetNode();
            if (!(theMethod.isClassInitializer() || theMethod.isConstructor() || theMethod.getAccessFlags().isStatic())) {
                theTable.register(theMethod, theClass);
            }
        });
        return theTable;
    }

    public BytecodeResolvedMethods resolvedMethods() {
        BytecodeLinkedClass theSuperclass = this.getSuperClass();
        BytecodeResolvedMethods theMap = theSuperclass != null ? theSuperclass.resolvedMethods() : new BytecodeResolvedMethods();
        for (BytecodeLinkedClass theImplementedInterface : this.getImplementingTypes(false, false)) {
            BytecodeResolvedMethods theInterfaceMethods = theImplementedInterface.resolvedMethods();
            theMap.merge(theInterfaceMethods);
        }
        this.outgoingEdges(BytecodeProvidesMethodEdgeType.filter()).forEach(aEdge -> theMap.register((BytecodeLinkedClass)aEdge.sourceNode(), (BytecodeMethod)aEdge.targetNode()));
        return theMap;
    }

    private void link(BytecodeTypeRef aTypeRef) {
        if (aTypeRef.isPrimitive()) {
            return;
        }
        if (aTypeRef instanceof BytecodeArrayTypeRef) {
            BytecodeArrayTypeRef theArrayRef = (BytecodeArrayTypeRef)aTypeRef;
            this.link(theArrayRef.getType());
            return;
        }
        if (aTypeRef instanceof BytecodeObjectTypeRef) {
            this.linkerContext.resolveClass((BytecodeObjectTypeRef)aTypeRef);
        }
    }

    public boolean resolveVirtualMethod(String aMethodName, BytecodeMethodSignature aSignature) {
        BytecodeLinkedClass theSuperClass;
        if (this.outgoingEdges(BytecodeProvidesMethodEdgeType.filter()).map(t -> (BytecodeMethod)t.targetNode()).anyMatch(t -> Objects.equals(t.getName().stringValue(), aMethodName) && t.getSignature().matchesExactlyTo(aSignature))) {
            return true;
        }
        boolean somethingFound = false;
        for (BytecodeLinkedClass theImplementedInterface : this.getImplementingTypes(false, false)) {
            if (!theImplementedInterface.resolveVirtualMethod(aMethodName, aSignature)) continue;
            somethingFound = true;
        }
        BytecodeMethod theMethod = this.bytecodeClass.methodByNameAndSignatureOrNull(aMethodName, aSignature);
        if (theMethod != null) {
            if (theMethod.getAccessFlags().isStatic()) {
                throw new IllegalStateException("Method " + aMethodName + " is static in " + this.className.name());
            }
            this.addEdgeTo(BytecodeProvidesMethodEdgeType.instance, theMethod);
            this.resolveMethodSignatureAndBody(theMethod);
            somethingFound = true;
        }
        if ((theSuperClass = this.getSuperClass()) != null && theSuperClass.resolveVirtualMethod(aMethodName, aSignature)) {
            return true;
        }
        return somethingFound;
    }

    public boolean resolveConstructorInvocation(BytecodeMethodSignature aSignature) {
        if (this.outgoingEdges(BytecodeProvidesMethodEdgeType.filter()).map(t -> (BytecodeMethod)t.targetNode()).anyMatch(t -> t.isConstructor() && t.getSignature().matchesExactlyTo(aSignature))) {
            return true;
        }
        BytecodeMethod theMethod = this.bytecodeClass.methodByNameAndSignatureOrNull("<init>", aSignature);
        if (theMethod != null) {
            if (theMethod.getAccessFlags().isStatic()) {
                throw new IllegalStateException("Constructor <init> is static in " + this.className.name());
            }
            this.addEdgeTo(BytecodeProvidesMethodEdgeType.instance, theMethod);
            this.resolveMethodSignatureAndBody(theMethod);
            return true;
        }
        return false;
    }

    public boolean resolvePrivateMethod(String aMethodName, BytecodeMethodSignature aSignature) {
        if (this.outgoingEdges(BytecodeProvidesMethodEdgeType.filter()).map(t -> (BytecodeMethod)t.targetNode()).anyMatch(t -> Objects.equals(t.getName().stringValue(), aMethodName) && t.getSignature().matchesExactlyTo(aSignature))) {
            return true;
        }
        BytecodeMethod theMethod = this.bytecodeClass.methodByNameAndSignatureOrNull(aMethodName, aSignature);
        if (theMethod != null) {
            if (theMethod.getAccessFlags().isStatic()) {
                throw new IllegalStateException("Method " + aMethodName + " is static in " + this.className.name());
            }
            this.addEdgeTo(BytecodeProvidesMethodEdgeType.instance, theMethod);
            this.resolveMethodSignatureAndBody(theMethod);
            return true;
        }
        return false;
    }

    public boolean resolveStaticMethod(String aMethodName, BytecodeMethodSignature aSignature) {
        if (this.outgoingEdges(BytecodeProvidesMethodEdgeType.filter()).map(t -> (BytecodeMethod)t.targetNode()).anyMatch(t -> t.getAccessFlags().isStatic() && Objects.equals(t.getName().stringValue(), aMethodName) && t.getSignature().matchesExactlyTo(aSignature))) {
            return true;
        }
        BytecodeMethod theMethod = this.bytecodeClass.methodByNameAndSignatureOrNull(aMethodName, aSignature);
        if (theMethod != null) {
            if (!theMethod.getAccessFlags().isStatic()) {
                throw new IllegalStateException("Method " + aMethodName + " is not static in " + this.className.name());
            }
            this.addEdgeTo(BytecodeProvidesMethodEdgeType.instance, theMethod);
            this.resolveMethodSignatureAndBody(theMethod);
            return true;
        }
        BytecodeLinkedClass theSuperClass = this.getSuperClass();
        if (theSuperClass != null) {
            return theSuperClass.resolveStaticMethod(aMethodName, aSignature);
        }
        return false;
    }

    private void resolveMethodSignatureAndBody(BytecodeMethod aMethod) {
        BytecodeMethodSignature theSignature = aMethod.getSignature();
        this.link(theSignature.getReturnType());
        for (BytecodeTypeRef theArgument : theSignature.getArguments()) {
            this.link(theArgument);
        }
        if (!aMethod.getAccessFlags().isAbstract()) {
            if (aMethod.getAccessFlags().isNative()) {
                if (this.bytecodeClass.getAttributes().getAnnotationByType(EmulatedByRuntime.class.getName()) == null) {
                    // empty if block
                }
            } else {
                BytecodeCodeAttributeInfo theCode = aMethod.getCode(this.bytecodeClass);
                BytecodeProgram theProgram = theCode.getProgram();
                for (BytecodeInstruction theInstruction : theProgram.getInstructions()) {
                    theInstruction.performLinking(this.bytecodeClass, this.linkerContext);
                }
                for (BytecodeExceptionTableEntry theHandler : theProgram.getExceptionHandlers()) {
                    if (theHandler.isFinally()) continue;
                    this.linkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(theHandler.getCatchType().getConstant()));
                }
            }
        }
    }

    public BytecodeClass getBytecodeClass() {
        return this.bytecodeClass;
    }

    public boolean hasClassInitializer() {
        return this.classInitializer != null;
    }

    private String simpleClassNameOf(String aFullQualifiedClassName) {
        int p = aFullQualifiedClassName.lastIndexOf(46);
        if (p >= 0) {
            return aFullQualifiedClassName.substring(p + 1);
        }
        return aFullQualifiedClassName;
    }

    public BytecodeImportedLink linkFor(BytecodeMethod aMethod) {
        BytecodeAnnotation theImportAnnotation = aMethod.getAttributes().getAnnotationByType(Import.class.getName());
        if (theImportAnnotation == null) {
            String theClassName = this.simpleClassNameOf(this.className.name());
            StringBuilder theMethodName = new StringBuilder(aMethod.getName().stringValue());
            for (BytecodeTypeRef theArgument : aMethod.getSignature().getArguments()) {
                theMethodName.append(this.simpleClassNameOf(theArgument.name()));
            }
            return new BytecodeImportedLink(theClassName.toLowerCase(), theMethodName.toString());
        }
        return new BytecodeImportedLink(theImportAnnotation.getElementValueByName("module").stringValue(), theImportAnnotation.getElementValueByName("name").stringValue());
    }

    public void resolveInheritedOverriddenMethods() {
        Set<BytecodeLinkedClass> theHierarchy = this.getImplementingTypes(true, false);
        for (BytecodeLinkedClass theClass : theHierarchy) {
            BytecodeResolvedMethods theResolvedMethods = theClass.resolvedMethods();
            List theInstanceMethods = theResolvedMethods.stream().filter(t -> !t.getValue().getAccessFlags().isPrivate() && !t.getValue().getAccessFlags().isStatic()).map(BytecodeResolvedMethods.MethodEntry::getValue).collect(Collectors.toList());
            for (BytecodeMethod theMethod : theInstanceMethods) {
                if (this.resolveVirtualMethod(theMethod.getName().stringValue(), theMethod.getSignature())) continue;
                throw new IllegalStateException("Cannot find method " + theMethod.getName() + " with signature " + theMethod.getSignature() + " in class " + theClass.getClassName().name());
            }
        }
    }

    public String toString() {
        return this.className.name();
    }
}

