/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeInstruction;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import java.util.HashSet;

public class BytecodeInstructionTABLESWITCH
extends BytecodeInstruction {
    private final long defaultValue;
    private final long lowValue;
    private final long highValue;
    private final long[] offsets;

    public BytecodeInstructionTABLESWITCH(BytecodeOpcodeAddress aOpcodeIndex, long aDefaultValue, long aLowValue, long aHighValue, long[] aOffsets) {
        super(aOpcodeIndex);
        this.defaultValue = aDefaultValue;
        this.lowValue = aLowValue;
        this.highValue = aHighValue;
        this.offsets = aOffsets;
    }

    public long getLowValue() {
        return this.lowValue;
    }

    public long getHighValue() {
        return this.highValue;
    }

    public long[] getOffsets() {
        return this.offsets;
    }

    @Override
    public BytecodeOpcodeAddress[] getPotentialJumpTargets() {
        HashSet<BytecodeOpcodeAddress> theResult = new HashSet<BytecodeOpcodeAddress>();
        for (long theOffset : this.getOffsets()) {
            theResult.add(this.getOpcodeAddress().add((int)theOffset));
        }
        theResult.add(this.getDefaultJumpTarget());
        return theResult.toArray(new BytecodeOpcodeAddress[theResult.size()]);
    }

    @Override
    public boolean isJumpSource() {
        return true;
    }

    public BytecodeOpcodeAddress getDefaultJumpTarget() {
        return this.getOpcodeAddress().add((int)this.defaultValue);
    }
}

