/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeClassinfoConstant;
import de.mirkosertic.bytecoder.core.BytecodeConstantPool;
import de.mirkosertic.bytecoder.core.BytecodeFieldRefConstant;
import de.mirkosertic.bytecoder.core.BytecodeInstruction;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeNameIndex;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;

public class BytecodeInstructionPUTFIELD
extends BytecodeInstruction {
    private final int poolIndex;
    private final BytecodeConstantPool constantPool;

    public BytecodeInstructionPUTFIELD(BytecodeOpcodeAddress aOpcodeIndex, int aPoolIndex, BytecodeConstantPool aConstantPool) {
        super(aOpcodeIndex);
        this.poolIndex = aPoolIndex;
        this.constantPool = aConstantPool;
    }

    public BytecodeFieldRefConstant getFieldRefConstant() {
        return (BytecodeFieldRefConstant)this.constantPool.constantByIndex(this.poolIndex - 1);
    }

    @Override
    public void performLinking(BytecodeClass aOwningClass, BytecodeLinkerContext aLinkerContext) {
        BytecodeFieldRefConstant theFieldRef = this.getFieldRefConstant();
        BytecodeClassinfoConstant theClass = theFieldRef.getClassIndex().getClassConstant();
        BytecodeNameIndex theName = theFieldRef.getNameAndTypeIndex().getNameAndType().getNameIndex();
        BytecodeLinkedClass theLinkedClass = aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(theClass.getConstant()));
        if (!theLinkedClass.resolveInstanceField(theName.getName())) {
            throw new IllegalStateException("Cannot link field " + theName.getName().stringValue() + " in " + theLinkedClass.getClassName().name());
        }
    }
}

