/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.classlib.Array;
import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeClassinfoConstant;
import de.mirkosertic.bytecoder.core.BytecodeConstantPool;
import de.mirkosertic.bytecoder.core.BytecodeInstruction;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;

public class BytecodeInstructionNEWMULTIARRAY
extends BytecodeInstruction {
    private final int typeIndex;
    private final BytecodeConstantPool constantPool;
    private final int dimensions;

    public BytecodeInstructionNEWMULTIARRAY(BytecodeOpcodeAddress aOpcodeIndex, int aTypeIndex, int aDimensions, BytecodeConstantPool aConstantPool) {
        super(aOpcodeIndex);
        this.typeIndex = aTypeIndex;
        this.constantPool = aConstantPool;
        this.dimensions = aDimensions;
    }

    public BytecodeClassinfoConstant getTypeConstant() {
        return (BytecodeClassinfoConstant)this.constantPool.constantByIndex(this.typeIndex - 1);
    }

    public BytecodeObjectTypeRef getObjectType() {
        return BytecodeObjectTypeRef.fromRuntimeClass(Array.class);
    }

    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public void performLinking(BytecodeClass aOwningClass, BytecodeLinkerContext aLinkerContext) {
        aLinkerContext.resolveClass(this.getObjectType());
        BytecodeClassinfoConstant theConstant = this.getTypeConstant();
        String theClassName = theConstant.getConstant().stringValue();
        BytecodeTypeRef[] theTypes = aLinkerContext.getSignatureParser().toTypes(theClassName);
        aLinkerContext.resolveTypeRef(theTypes[0]);
    }
}

