/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeClassinfoConstant;
import de.mirkosertic.bytecoder.core.BytecodeConstantPool;
import de.mirkosertic.bytecoder.core.BytecodeInstruction;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;

public class BytecodeInstructionNEW
extends BytecodeInstruction {
    private final int index;
    private final BytecodeConstantPool constantPool;

    public BytecodeInstructionNEW(BytecodeOpcodeAddress aOpcodeIndex, int aIndex, BytecodeConstantPool aConstantPool) {
        super(aOpcodeIndex);
        this.index = aIndex;
        this.constantPool = aConstantPool;
    }

    public BytecodeClassinfoConstant getClassInfoForObjectToCreate() {
        return (BytecodeClassinfoConstant)this.constantPool.constantByIndex(this.index - 1);
    }

    @Override
    public void performLinking(BytecodeClass aOwningClass, BytecodeLinkerContext aLinkerContext) {
        BytecodeObjectTypeRef theObjectType = BytecodeObjectTypeRef.fromUtf8Constant(this.getClassInfoForObjectToCreate().getConstant());
        aLinkerContext.resolveClass(theObjectType);
    }
}

