/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeInstruction;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import java.util.HashSet;

public class BytecodeInstructionLOOKUPSWITCH
extends BytecodeInstruction {
    private final long defaultValue;
    private final Pair[] pairs;

    public BytecodeInstructionLOOKUPSWITCH(BytecodeOpcodeAddress aIndex, long aDefaultValue, Pair[] aPairs) {
        super(aIndex);
        this.defaultValue = aDefaultValue;
        this.pairs = aPairs;
    }

    public Pair[] getPairs() {
        return this.pairs;
    }

    public BytecodeOpcodeAddress getDefaultJumpTarget() {
        return this.getOpcodeAddress().add((int)this.defaultValue);
    }

    @Override
    public BytecodeOpcodeAddress[] getPotentialJumpTargets() {
        HashSet<BytecodeOpcodeAddress> theResult = new HashSet<BytecodeOpcodeAddress>();
        for (Pair thePair : this.pairs) {
            theResult.add(this.getOpcodeAddress().add((int)thePair.offset));
        }
        theResult.add(this.getDefaultJumpTarget());
        return theResult.toArray(new BytecodeOpcodeAddress[theResult.size()]);
    }

    @Override
    public boolean isJumpSource() {
        return true;
    }

    public static class Pair {
        private final long match;
        private final long offset;

        public Pair(long match, long offset) {
            this.match = match;
            this.offset = offset;
        }

        public long getMatch() {
            return this.match;
        }

        public long getOffset() {
            return this.offset;
        }
    }
}

