/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.classlib.Array;
import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeClassinfoConstant;
import de.mirkosertic.bytecoder.core.BytecodeConstantPool;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericInvoke;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeMethodRefConstant;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeNameAndTypeConstant;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;

public class BytecodeInstructionINVOKEVIRTUAL
extends BytecodeInstructionGenericInvoke {
    public BytecodeInstructionINVOKEVIRTUAL(BytecodeOpcodeAddress aOpcodeIndex, int aIndex, BytecodeConstantPool aConstantPool) {
        super(aOpcodeIndex, aIndex, aConstantPool);
    }

    @Override
    public void performLinking(BytecodeClass aOwningClass, BytecodeLinkerContext aLinkerContext) {
        BytecodeMethodRefConstant theMethodRefConstant = this.getMethodReference();
        BytecodeClassinfoConstant theClassConstant = theMethodRefConstant.getClassIndex().getClassConstant();
        BytecodeNameAndTypeConstant theMethodRef = theMethodRefConstant.getNameAndTypeIndex().getNameAndType();
        BytecodeMethodSignature theSig = theMethodRef.getDescriptorIndex().methodSignature();
        BytecodeUtf8Constant theName = theMethodRef.getNameIndex().getName();
        BytecodeUtf8Constant theConstant = theClassConstant.getConstant();
        String theClassName = theConstant.stringValue();
        if (theClassName.startsWith("[")) {
            BytecodeTypeRef[] theTypes = aLinkerContext.getSignatureParser().toTypes(theClassName);
            BytecodeTypeRef theSingleType = theTypes[0];
            aLinkerContext.resolveTypeRef(theSingleType);
            BytecodeObjectTypeRef theTypeRef = BytecodeObjectTypeRef.fromRuntimeClass(Array.class);
            BytecodeLinkedClass theClass = aLinkerContext.resolveClass(theTypeRef);
            if (!theClass.resolveVirtualMethod(theName.stringValue(), theSig) && !theClass.getBytecodeClass().getAccessFlags().isAbstract()) {
                throw new IllegalStateException("Cannot find virtual method " + theName.stringValue() + " in non-abstract class " + theClassConstant.getConstant().stringValue() + " with signature " + theSig.toString());
            }
        } else {
            BytecodeLinkedClass theClass = aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(theConstant));
            if (!theClass.resolveVirtualMethod(theName.stringValue(), theSig) && !theClass.getBytecodeClass().getAccessFlags().isAbstract()) {
                throw new IllegalStateException("Cannot find virtual method " + theName.stringValue() + " in non-abstract class " + theClassConstant.getConstant().stringValue() + " with signature " + theSig.toString());
            }
        }
    }
}

