/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeBootstrapMethod;
import de.mirkosertic.bytecoder.core.BytecodeBootstrapMethodsAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeConstant;
import de.mirkosertic.bytecoder.core.BytecodeConstantPool;
import de.mirkosertic.bytecoder.core.BytecodeInstruction;
import de.mirkosertic.bytecoder.core.BytecodeInstructionInvoke;
import de.mirkosertic.bytecoder.core.BytecodeInvokeDynamicConstant;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodHandleConstant;
import de.mirkosertic.bytecoder.core.BytecodeMethodRefConstant;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeMethodTypeConstant;
import de.mirkosertic.bytecoder.core.BytecodeNameAndTypeConstant;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.core.BytecodeReferenceKind;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;

public class BytecodeInstructionINVOKEDYNAMIC
extends BytecodeInstruction
implements BytecodeInstructionInvoke {
    private final int index;
    private final BytecodeConstantPool constantPool;

    public BytecodeInstructionINVOKEDYNAMIC(BytecodeOpcodeAddress aIndex, int aConstantIndex, BytecodeConstantPool aConstantPool) {
        super(aIndex);
        this.index = aConstantIndex;
        this.constantPool = aConstantPool;
    }

    public BytecodeInvokeDynamicConstant getCallSite() {
        return (BytecodeInvokeDynamicConstant)this.constantPool.constantByIndex(this.index - 1);
    }

    private void link(BytecodeLinkerContext aLinkerContext, BytecodeReferenceKind aKind, BytecodeConstant aReference) {
        switch (aKind) {
            case REF_invokeStatic: {
                BytecodeMethodRefConstant theStaticReference = (BytecodeMethodRefConstant)aReference;
                BytecodeLinkedClass theLinkedClass = aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(theStaticReference.getClassIndex().getClassConstant().getConstant()));
                BytecodeNameAndTypeConstant theNameAndType = theStaticReference.getNameAndTypeIndex().getNameAndType();
                theLinkedClass.resolveVirtualMethod(theNameAndType.getNameIndex().getName().stringValue(), theNameAndType.getDescriptorIndex().methodSignature());
                break;
            }
            default: {
                throw new IllegalStateException("Not implemented refkind for invokedynamic : " + (Object)((Object)aKind));
            }
        }
    }

    private void linkSignature(BytecodeMethodSignature signature, BytecodeLinkerContext context) {
        context.resolveTypeRef(signature.getReturnType());
        for (BytecodeTypeRef ref : signature.getArguments()) {
            context.resolveTypeRef(ref);
        }
    }

    @Override
    public void performLinking(BytecodeClass aOwningClass, BytecodeLinkerContext aLinkerContext) {
        BytecodeInvokeDynamicConstant theConstant = this.getCallSite();
        BytecodeBootstrapMethodsAttributeInfo theBootStrapMethods = aOwningClass.getAttributes().getByType(BytecodeBootstrapMethodsAttributeInfo.class);
        BytecodeBootstrapMethod theBootstrapMethod = theBootStrapMethods.methodByIndex(theConstant.getBootstrapMethodAttributeIndex().getIndex());
        for (BytecodeConstant constant : theBootstrapMethod.getArguments()) {
            if (!(constant instanceof BytecodeMethodTypeConstant)) continue;
            BytecodeMethodTypeConstant m = (BytecodeMethodTypeConstant)constant;
            BytecodeMethodSignature theSignature = m.getDescriptorIndex().methodSignature();
            this.linkSignature(theSignature, aLinkerContext);
        }
        BytecodeMethodSignature theInitSignature = theConstant.getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature();
        this.linkSignature(theInitSignature, aLinkerContext);
        BytecodeMethodHandleConstant theMethodRef = theBootstrapMethod.getMethodRef();
        BytecodeMethodRefConstant theBootstrapMethodToInvoke = (BytecodeMethodRefConstant)theMethodRef.getReferenceIndex().getConstant();
        switch (theMethodRef.getReferenceKind()) {
            case REF_invokeStatic: {
                aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(theBootstrapMethodToInvoke.getClassIndex().getClassConstant().getConstant())).resolveStaticMethod(theBootstrapMethodToInvoke.getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue(), theBootstrapMethodToInvoke.getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature());
                for (BytecodeConstant theBootstrapArgument : theBootstrapMethod.getArguments()) {
                    if (!(theBootstrapArgument instanceof BytecodeMethodHandleConstant)) continue;
                    BytecodeMethodHandleConstant theHandle = (BytecodeMethodHandleConstant)theBootstrapArgument;
                    BytecodeMethodRefConstant theImplementingMethodRef = (BytecodeMethodRefConstant)theHandle.getReferenceIndex().getConstant();
                    BytecodeObjectTypeRef theClass = BytecodeObjectTypeRef.fromUtf8Constant(theImplementingMethodRef.getClassIndex().getClassConstant().getConstant());
                    BytecodeLinkedClass theLinkedClass = aLinkerContext.resolveClass(theClass);
                    BytecodeMethod theMethod = theLinkedClass.getBytecodeClass().methodByNameAndSignatureOrNull(theImplementingMethodRef.getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue(), theImplementingMethodRef.getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature());
                    if (theMethod.getAccessFlags().isStatic()) {
                        theLinkedClass.resolveStaticMethod(theImplementingMethodRef.getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue(), theImplementingMethodRef.getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature());
                        continue;
                    }
                    if (theMethod.getAccessFlags().isPrivate()) {
                        theLinkedClass.resolvePrivateMethod(theImplementingMethodRef.getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue(), theImplementingMethodRef.getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature());
                        continue;
                    }
                    theLinkedClass.resolveVirtualMethod(theImplementingMethodRef.getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue(), theImplementingMethodRef.getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Nut supported reference kind for invoke dynamic : " + (Object)((Object)theMethodRef.getReferenceKind()));
            }
        }
        this.link(aLinkerContext, theMethodRef.getReferenceKind(), theMethodRef.getReferenceIndex().getConstant());
    }
}

