/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeClassinfoConstant;
import de.mirkosertic.bytecoder.core.BytecodeConstantPool;
import de.mirkosertic.bytecoder.core.BytecodeInstruction;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;

public class BytecodeInstructionINSTANCEOF
extends BytecodeInstruction {
    private final int constantIndex;
    private final BytecodeConstantPool constantPool;

    public BytecodeInstructionINSTANCEOF(BytecodeOpcodeAddress aOpcodeIndex, int aConstantIndex, BytecodeConstantPool aConstantPool) {
        super(aOpcodeIndex);
        this.constantIndex = aConstantIndex;
        this.constantPool = aConstantPool;
    }

    public BytecodeClassinfoConstant getTypeRef() {
        return (BytecodeClassinfoConstant)this.constantPool.constantByIndex(this.constantIndex - 1);
    }

    @Override
    public void performLinking(BytecodeClass aOwningClass, BytecodeLinkerContext aLinkerContext) {
        BytecodeClassinfoConstant theType = this.getTypeRef();
        BytecodeUtf8Constant theName = theType.getConstant();
        if (theName.stringValue().startsWith("[")) {
            BytecodeTypeRef theTypeRef = aLinkerContext.getSignatureParser().toFieldType(theName);
            aLinkerContext.resolveTypeRef(theTypeRef);
        } else {
            aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(theName));
        }
    }
}

