/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeInstruction;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;

public class BytecodeInstructionIFICMP
extends BytecodeInstruction {
    private final Type type;
    private final int jumpOffset;

    public BytecodeInstructionIFICMP(BytecodeOpcodeAddress aOpcodeIndex, Type aType, int aJumpOffset) {
        super(aOpcodeIndex);
        this.type = aType;
        this.jumpOffset = aJumpOffset;
    }

    public Type getType() {
        return this.type;
    }

    public BytecodeOpcodeAddress getJumpTarget() {
        return this.getOpcodeAddress().add(this.jumpOffset);
    }

    @Override
    public BytecodeOpcodeAddress[] getPotentialJumpTargets() {
        return new BytecodeOpcodeAddress[]{this.getJumpTarget()};
    }

    @Override
    public boolean isJumpSource() {
        return true;
    }

    public static enum Type {
        eq,
        ne,
        lt,
        ge,
        gt,
        le;

    }
}

