/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeInstruction;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;

public class BytecodeInstructionIFACMP
extends BytecodeInstruction {
    private final Type type;
    private final int jumpOffset;

    public BytecodeInstructionIFACMP(BytecodeOpcodeAddress aIndex, Type aType, int aJumpOffset) {
        super(aIndex);
        this.type = aType;
        this.jumpOffset = aJumpOffset;
    }

    public Type getType() {
        return this.type;
    }

    public BytecodeOpcodeAddress getJumpTarget() {
        return this.getOpcodeAddress().add(this.jumpOffset);
    }

    @Override
    public BytecodeOpcodeAddress[] getPotentialJumpTargets() {
        return new BytecodeOpcodeAddress[]{this.getJumpTarget()};
    }

    @Override
    public boolean isJumpSource() {
        return true;
    }

    public static enum Type {
        eq,
        ne;

    }
}

